/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.entity.ia;

import com.google.common.collect.Lists;
import com.soytutta.mynethersdelight.common.block.MagmaCakeBlock;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EatMagmaCakeGoal
extends Goal {
    private static final int COOLDOWN_TICKS = 100;
    private static final int TONGUE_ANIMATION_DURATION = 10;
    private static final SoundEvent TONGUE_SOUND = SoundEvents.f_215692_;
    private final Frog frog;
    private final Level level;
    private Object targetPos;
    private int eatAnimationTick;
    private int tongueAnimationTick;
    private int cooldownTick;

    public EatMagmaCakeGoal(Frog frog) {
        this.frog = frog;
        this.level = frog.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.updateTarget();
        return this.targetPos != null;
    }

    public void m_8056_() {
        this.moveToTarget();
    }

    public void m_8041_() {
        this.targetPos = null;
        this.eatAnimationTick = 0;
        this.tongueAnimationTick = 0;
        this.cooldownTick = 100;
        this.frog.m_20124_(Pose.STANDING);
    }

    public boolean m_8045_() {
        return this.targetPos != null;
    }

    public void m_8037_() {
        Entity entity;
        double distanceSq;
        if (this.cooldownTick > 0) {
            --this.cooldownTick;
            return;
        }
        this.updateTarget();
        this.moveToTarget();
        if (this.targetPos instanceof BlockPos) {
            BlockPos pos = (BlockPos)this.targetPos;
            double distanceSq2 = this.frog.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (distanceSq2 <= 3.0625) {
                this.handleBlockInteraction(pos);
            }
        } else if (this.targetPos instanceof Entity && (distanceSq = this.frog.m_20275_((entity = (Entity)this.targetPos).m_20185_(), entity.m_20186_(), entity.m_20189_())) <= 3.0625) {
            this.handleEntityInteraction(entity);
        }
    }

    private void updateTarget() {
        List<BlockPos> nearbyCakes = this.findNearbyCakes();
        double minDistanceSq = Double.MAX_VALUE;
        BlockPos closestTarget = null;
        BlockPos frogPos = this.frog.m_20183_();
        for (BlockPos cakePos : nearbyCakes) {
            double distanceSq = frogPos.m_123331_((Vec3i)cakePos);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            closestTarget = cakePos;
        }
        Player player = this.level.m_45930_((Entity)this.frog, 6.0);
        if (player != null && player.m_20280_((Entity)this.frog) <= 36.0) {
            double playerDistanceSq;
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            if ((mainHand.m_41720_() == MNDItems.MAGMA_CAKE.get() || mainHand.m_41720_() == MNDItems.MAGMA_CAKE_SLICE.get() || offHand.m_41720_() == MNDItems.MAGMA_CAKE.get() || offHand.m_41720_() == MNDItems.MAGMA_CAKE_SLICE.get()) && (playerDistanceSq = frogPos.m_123331_((Vec3i)player.m_20183_())) < minDistanceSq) {
                minDistanceSq = playerDistanceSq;
                closestTarget = player;
            }
        }
        this.targetPos = closestTarget;
    }

    private void moveToTarget() {
        if (this.targetPos instanceof BlockPos) {
            BlockPos pos = (BlockPos)this.targetPos;
            this.frog.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.5);
        } else if (this.targetPos instanceof Entity) {
            Entity entity = (Entity)this.targetPos;
            this.frog.m_21573_().m_26519_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1.5);
        }
    }

    private void handleBlockInteraction(BlockPos pos) {
        this.frog.m_21573_().m_26573_();
        this.frog.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ++this.eatAnimationTick;
        if (this.eatAnimationTick == 1) {
            this.level.m_6269_(null, (Entity)this.frog, TONGUE_SOUND, SoundSource.NEUTRAL, 2.0f, 1.0f);
            this.frog.m_20124_(Pose.USING_TONGUE);
            this.frog.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            BlockState state = this.level.m_8055_(pos);
            if (state.m_60734_() instanceof MagmaCakeBlock) {
                for (int i = 0; i < 3; ++i) {
                    MagmaCube magmacube = (MagmaCube)EntityType.f_20468_.m_20615_(this.level);
                    if (magmacube == null) continue;
                    magmacube.m_7839_(1, true);
                    magmacube.m_21153_(1.0f);
                    magmacube.m_6842_(true);
                    magmacube.m_6034_(this.frog.m_20185_(), this.frog.m_20186_(), this.frog.m_20189_());
                    this.level.m_7967_((Entity)magmacube);
                    this.frog.m_7327_((Entity)magmacube);
                    if (magmacube.m_6084_()) continue;
                    magmacube.m_142687_(Entity.RemovalReason.KILLED);
                }
                this.frog.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
                int bites = (Integer)state.m_61143_((Property)MagmaCakeBlock.BITES);
                if (bites < 6) {
                    this.level.m_46597_(pos, (BlockState)state.m_61124_((Property)MagmaCakeBlock.BITES, (Comparable)Integer.valueOf(bites + 1)));
                } else if (((Boolean)state.m_61143_((Property)MagmaCakeBlock.SECOND_CAKE)).booleanValue()) {
                    this.level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)MagmaCakeBlock.BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)MagmaCakeBlock.SECOND_CAKE, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.level.m_46961_(pos, false);
                }
                this.cooldownTick = 100;
            }
        }
        if (this.tongueAnimationTick < 10) {
            this.frog.m_21563_().m_24946_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            ++this.tongueAnimationTick;
        } else {
            this.m_8041_();
        }
    }

    private void handleEntityInteraction(Entity entity) {
        this.frog.m_21573_().m_26573_();
        this.frog.m_21563_().m_24946_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            if (mainHand.m_41720_() == MNDItems.MAGMA_CAKE_SLICE.get() || offHand.m_41720_() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                ++this.eatAnimationTick;
                if (this.eatAnimationTick == 1) {
                    this.level.m_6269_(null, (Entity)this.frog, TONGUE_SOUND, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    this.frog.m_20124_(Pose.USING_TONGUE);
                    this.frog.m_21563_().m_24946_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    if (mainHand.m_41720_() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                        mainHand.m_41774_(1);
                    } else if (offHand.m_41720_() == MNDItems.MAGMA_CAKE_SLICE.get()) {
                        offHand.m_41774_(1);
                    }
                    for (int i = 0; i < 3; ++i) {
                        MagmaCube magmacube = (MagmaCube)EntityType.f_20468_.m_20615_(this.level);
                        if (magmacube == null) continue;
                        magmacube.m_7839_(1, true);
                        magmacube.m_21153_(1.0f);
                        magmacube.m_6842_(true);
                        magmacube.m_6034_(this.frog.m_20185_(), this.frog.m_20186_(), this.frog.m_20189_());
                        this.level.m_7967_((Entity)magmacube);
                        this.frog.m_7327_((Entity)magmacube);
                        if (magmacube.m_6084_()) continue;
                        magmacube.m_142687_(Entity.RemovalReason.KILLED);
                    }
                    this.frog.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
                }
            }
        }
        if (this.tongueAnimationTick < 10) {
            this.frog.m_21563_().m_24946_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            ++this.tongueAnimationTick;
        } else {
            this.m_8041_();
        }
    }

    private List<BlockPos> findNearbyCakes() {
        ArrayList cakePositions = Lists.newArrayList();
        BlockPos frogPos = this.frog.m_20183_();
        int searchRadius = 10;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos pos = frogPos.m_7918_(x, y, z);
                    if (!(this.level.m_8055_(pos).m_60734_() instanceof MagmaCakeBlock)) continue;
                    cakePositions.add(pos);
                }
            }
        }
        return cakePositions;
    }
}

