/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.effect;

import com.soytutta.mynethersdelight.common.registry.MNDEffects;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PungentEffect
extends MobEffect {
    public PungentEffect() {
        super(MobEffectCategory.NEUTRAL, 0);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        MobEffectInstance fireResistanceEffect = entity.m_21124_(MobEffects.f_19607_);
        MobEffectInstance BPungentEffect = entity.m_21124_((MobEffect)MNDEffects.BPUNGENT.get());
        MobEffectInstance GPungentEffect = entity.m_21124_((MobEffect)MNDEffects.GPUNGENT.get());
        boolean hasFireProtectionArmor = StreamSupport.stream(entity.m_6168_().spliterator(), false).anyMatch(item -> EnchantmentHelper.m_44831_((ItemStack)item).containsKey(Enchantments.f_44966_));
        if (entity.m_5825_() || fireResistanceEffect != null || hasFireProtectionArmor) {
            this.switchEffect(entity, BPungentEffect, (MobEffect)MNDEffects.GPUNGENT.get());
        } else {
            this.switchEffect(entity, GPungentEffect, (MobEffect)MNDEffects.BPUNGENT.get());
        }
        if (this.isInFireCondition(entity) || entity.m_20077_() || entity.m_6060_()) {
            float minHealth;
            float f = amplifier >= 2 ? 2.0f : (minHealth = amplifier == 1 ? entity.m_21233_() / 2.0f : entity.m_21233_() - entity.m_21233_() / 4.0f);
            if (entity.m_21223_() > minHealth) {
                entity.m_6469_(entity.m_269291_().m_269425_(), 1.0f);
            }
            if (this.isInFireCondition(entity)) {
                if (entity.m_21223_() > minHealth) {
                    entity.m_20254_(3);
                }
            } else if (entity.m_6060_()) {
                entity.m_20254_(0);
                entity.m_20095_();
            }
        }
    }

    private void switchEffect(LivingEntity entity, MobEffectInstance currentEffect, MobEffect newEffect) {
        if (currentEffect != null) {
            int duration = currentEffect.m_19557_();
            int level = currentEffect.m_19564_();
            entity.m_21195_(currentEffect.m_19544_());
            entity.m_7292_(new MobEffectInstance(newEffect, duration, level));
        }
    }

    private boolean isInFireCondition(LivingEntity entity) {
        Level world = entity.m_9236_();
        BlockPos entityPos = entity.m_20183_();
        boolean isOnFlame = false;
        int areaSize = 1;
        for (int x = -areaSize; x <= areaSize; ++x) {
            for (int y = -areaSize; y <= areaSize; ++y) {
                for (int z = -areaSize; z <= areaSize; ++z) {
                    BlockPos pos = entityPos.m_7918_(x, y, z);
                    BlockState blockState = world.m_8055_(pos);
                    if (!blockState.m_204336_(MNDTags.LETIOS_FLAMES) || blockState.m_61138_((Property)BlockStateProperties.f_61443_) && (!blockState.m_61138_((Property)BlockStateProperties.f_61443_) || !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue())) continue;
                    isOnFlame = true;
                    break;
                }
                if (isOnFlame) break;
            }
            if (isOnFlame) break;
        }
        return isOnFlame;
    }

    public boolean m_6584_(int duration, int amplifier) {
        int i = 25 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

