/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics;

import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.liukrast.eg.EGConstants;
import net.liukrast.eg.api.logistics.ColoredFactoryPanelSupportBehaviour;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.util.DCFinder;
import net.liukrast.eg.registry.EGBlockEntityTypes;
import net.liukrast.eg.registry.EGPanelConnections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class DisplayCollectorBlockEntity
extends DisplayLinkBlockEntity {
    private Component component;

    public DisplayCollectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EGBlockEntityTypes.DISPLAY_COLLECTOR.get(), pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.factoryPanelSupport = new ColoredFactoryPanelSupportBehaviour(be -> {
            AbstractPanelBehaviour ab;
            boolean bool = !(be instanceof AbstractPanelBehaviour) || (ab = (AbstractPanelBehaviour)((Object)be)).hasConnection((PanelConnection)EGPanelConnections.STRING.get());
            return new ColoredFactoryPanelSupportBehaviour.Line(bool ? -1 : 0x888898, true);
        }, (SmartBlockEntity)this, () -> true, () -> false, () -> {});
        behaviours.add((BlockEntityBehaviour)this.factoryPanelSupport);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (!tag.m_128441_("text")) {
            return;
        }
        ExtraCodecs.f_276686_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("text")).resultOrPartial(arg_0 -> ((Logger)EGConstants.LOGGER).error(arg_0)).ifPresent(text -> {
            this.component = text;
        });
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.component != null) {
            ExtraCodecs.f_276686_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.component).resultOrPartial(arg_0 -> ((Logger)EGConstants.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.m_128365_("text", tag1));
        }
    }

    public Component getComponent() {
        return this.component == null ? Component.m_237119_() : this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.factoryPanelSupport.notifyPanels();
    }

    public BlockPos getSourcePosition() {
        return this.f_58858_.m_121955_((Vec3i)this.targetOffset);
    }

    public BlockPos getTargetPosition() {
        Iterator iterator = this.factoryPanelSupport.getLinkedPanels().iterator();
        if (iterator.hasNext()) {
            FactoryPanelPosition position = (FactoryPanelPosition)iterator.next();
            return position.pos();
        }
        return this.f_58858_.m_121945_(this.getDirection());
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ == null) {
            return;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.getSourcePosition());
        if (!(be instanceof DCFinder)) {
            return;
        }
        DCFinder finder = (DCFinder)be;
        Set<BlockPos> set = finder.extra_gauges$targetingDisplayCollectors();
        if (set.contains(this.m_58899_())) {
            return;
        }
        set.add(this.m_58899_());
        be.m_6596_();
    }
}

