/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import java.util.Map;
import net.liukrast.eg.EGConstants;
import net.liukrast.eg.networking.PanelCacheUpdatePacket;
import net.liukrast.eg.registry.RegisterPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

public interface CacheContainer<T> {
    public Codec<T> cacheCodec();

    public Map<BlockPos, T> cacheMap();

    default public void setCache(CompoundTag tag, DynamicOps<Tag> dynamicOps) {
        Map cache = this.cacheMap();
        Codec<T> codec = this.cacheCodec();
        cache.clear();
        for (String key : tag.m_128431_()) {
            String[] t = key.split(",");
            try {
                BlockPos pos = new BlockPos(Integer.parseInt(t[0]), Integer.parseInt(t[1]), Integer.parseInt(t[2]));
                codec.parse(dynamicOps, (Object)tag.m_128423_(key)).resultOrPartial(arg_0 -> ((Logger)EGConstants.LOGGER).error(arg_0)).ifPresent(r -> cache.put(pos, r));
            }
            catch (NumberFormatException e) {
                EGConstants.LOGGER.error("Unable to parse compound tag {}", (Object)tag.m_128423_(key), (Object)e);
            }
        }
    }

    default public void getCache(CompoundTag tag, DynamicOps<Tag> dynamicOps) {
        Map<BlockPos, T> cache = this.cacheMap();
        Codec<T> codec = this.cacheCodec();
        for (BlockPos pos : cache.keySet()) {
            String key = pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_();
            codec.encodeStart(dynamicOps, cache.get(pos)).resultOrPartial(arg_0 -> ((Logger)EGConstants.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.m_128365_(key, tag1));
        }
    }

    default public void sendCache(FactoryPanelBehaviour behaviour) {
        Level level = behaviour.blockEntity.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        this.getCache(tag, (DynamicOps<Tag>)NbtOps.f_128958_);
        RegisterPackets.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(behaviour.blockEntity.m_58899_())), (Object)new PanelCacheUpdatePacket(behaviour.getPanelPosition(), tag));
    }
}

