/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.core.AppEng;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.button.HighlightButton;
import com.glodblock.github.extendedae.common.me.wireless.WirelessStatus;
import com.glodblock.github.extendedae.container.ContainerWirelessHub;
import com.glodblock.github.extendedae.network.EPPNetworkHandler;
import com.glodblock.github.extendedae.util.MessageUtil;
import com.glodblock.github.glodium.network.packet.CGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiWirelessHub
extends UpgradeableScreen<ContainerWirelessHub> {
    private static final Blitter PORT = Blitter.texture((ResourceLocation)AppEng.makeId((String)"textures/guis/wireless_hub.png")).src(176, 0, 16, 16);
    private static final int COL1_X = 37;
    private static final int COL2_X = 120;
    private static final int COL_Y = 44;
    private static final int Y_OFFSET = 28;
    private static final int PADDING_X = 8;
    private static final int PADDING_Y = 6;
    private final RemoteBlock[] remotes = new RemoteBlock[8];
    private final HighlightButton[] highlightBtn = new HighlightButton[8];
    private final ActionEPPButton[] disconnectBtn = new ActionEPPButton[8];

    public GuiWirelessHub(ContainerWirelessHub menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        for (int i = 0; i < 8; ++i) {
            int port = i;
            this.remotes[i] = new RemoteBlock(() -> menu.getRemotePosition(port), 0, 0, 16, 16);
            this.highlightBtn[i] = new HighlightButton();
            this.highlightBtn[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.wireless_connect.highlight.tooltip")));
            this.disconnectBtn[i] = new ActionEPPButton(b -> EPPNetworkHandler.INSTANCE.sendToServer((IMessage)new CGenericPacket("disconnect", new Object[]{port})), Icon.CLEAR);
            this.disconnectBtn[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.wireless_hub.disconnect.tooltip")));
        }
    }

    public void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < 8; ++i) {
            int X = i < 4 ? 37 : 120;
            int Y = i % 4;
            this.remotes[i].m_264152_(this.f_97735_ + X, this.f_97736_ + 44 + Y * 28);
            this.highlightBtn[i].m_264152_(this.f_97735_ + X - 18, this.f_97736_ + 44 + Y * 28);
            this.disconnectBtn[i].m_264152_(this.f_97735_ + X + 18, this.f_97736_ + 44 + Y * 28);
            this.m_169394_((Renderable)this.remotes[i]);
            this.m_142416_((GuiEventListener)this.highlightBtn[i]);
            this.m_142416_((GuiEventListener)this.disconnectBtn[i]);
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        ResourceKey dim = this.getPlayer().f_108545_.m_46472_();
        for (int i = 0; i < 8; ++i) {
            WirelessStatus status = ((ContainerWirelessHub)this.f_97732_).getStatus(i);
            if (status == WirelessStatus.WORKING || status == WirelessStatus.NO_POWER) {
                BlockPos remotePos = ((ContainerWirelessHub)this.f_97732_).getRemotePosition(i);
                this.highlightBtn[i].f_93623_ = true;
                this.highlightBtn[i].setTarget(remotePos, (ResourceKey<Level>)dim);
                this.highlightBtn[i].setMultiplier(this.playerToBlockDis(remotePos));
                this.highlightBtn[i].setSuccessJob(() -> {
                    if (this.getPlayer() != null) {
                        Component message = MessageUtil.createEnhancedHighlightMessage((Player)this.getPlayer(), remotePos, (ResourceKey<Level>)this.getPlayer().f_108545_.m_46472_(), "chat.wireless.highlight");
                        this.getPlayer().m_5661_(message, false);
                    }
                });
                this.remotes[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"gui.wireless_connect.remote", (Object[])new Object[]{remotePos.m_123341_(), remotePos.m_123342_(), remotePos.m_123343_()})));
                this.remotes[i].setConnected(true);
                continue;
            }
            this.highlightBtn[i].f_93623_ = false;
            this.remotes[i].m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.wireless_hub.empty_port.tooltip")));
            this.remotes[i].setConnected(false);
        }
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int len = 12;
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.wireless_connect.power", (Object[])new Object[]{String.format("%.2f", ((ContainerWirelessHub)this.f_97732_).powerUse)}), 8, 6 + len, textColor, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.wireless_connect.channel", (Object[])new Object[]{((ContainerWirelessHub)this.f_97732_).usedChannel, ((ContainerWirelessHub)this.f_97732_).maxChannel}), 8, 6 + len * 2, textColor, false);
    }

    private double playerToBlockDis(BlockPos pos) {
        if (pos == null) {
            return 0.0;
        }
        BlockPos ps = this.getPlayer().m_20097_();
        return pos.m_123331_((Vec3i)ps);
    }

    private static class RemoteBlock
    extends AbstractWidget {
        private final Supplier<BlockPos> locator;
        @Nullable
        private BlockPos localPos;
        private ItemStack localBlock = ItemStack.f_41583_;
        private boolean isConnected = false;

        public RemoteBlock(Supplier<BlockPos> locator, int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.locator = locator;
        }

        private void setConnected(boolean connected) {
            this.isConnected = connected;
        }

        protected void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            if (this.localPos != this.locator.get() && Minecraft.m_91087_().f_91073_ != null) {
                this.localPos = this.locator.get();
                this.localBlock = new ItemStack((ItemLike)Minecraft.m_91087_().f_91073_.m_8055_(this.localPos).m_60734_());
            }
            if (this.isConnected) {
                graphics.m_280064_(this.localBlock, this.m_252754_(), this.m_252907_(), 0, 3);
            } else {
                PORT.dest(this.m_252754_(), this.m_252907_()).blit(graphics);
            }
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

