/*
 * Decompiled with CFR 0.152.
 */
package me.litchi.ftbqlocal.handler.impl;

import com.mojang.text2speech.Narrator;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import me.litchi.ftbqlocal.handler.FtbQHandler;
import me.litchi.ftbqlocal.service.impl.JSONService;
import me.litchi.ftbqlocal.utils.HandlerCounter;
import net.minecraft.network.chat.Component;

public class Handler
implements FtbQHandler {
    private final TreeMap<String, String> transKeys = HandlerCounter.transKeys;
    private final JSONService handleJSON = new JSONService();

    @Override
    public void handleRewardTables(List<RewardTable> rewardTables) {
        rewardTables.forEach(rewardTable -> {
            HandlerCounter.addCounter();
            this.transKeys.put("ftbquests.loot_table." + rewardTable.id + ".title", HandlerCounter.addPercent(rewardTable.getRawTitle()));
            rewardTable.setRawTitle("{ftbquests.loot_table." + rewardTable.id + ".title}");
        });
        HandlerCounter.setCounter(0);
    }

    @Override
    public void handleChapterGroup(ChapterGroup chapterGroup) {
        if (chapterGroup.getTitle() != null && !chapterGroup.getRawTitle().isEmpty()) {
            this.transKeys.put("ftbquests.chapter_groups." + chapterGroup.id + ".title", HandlerCounter.addPercent(chapterGroup.getRawTitle()));
            chapterGroup.setRawTitle("{ftbquests.chapter_groups." + chapterGroup.id + ".title}");
            HandlerCounter.addCounter();
        }
    }

    @Override
    public void handleChapter(Chapter chapter) {
        HandlerCounter.setPrefix("ftbquests.chapter." + chapter.getFilename());
        String prefix = HandlerCounter.getPrefix();
        if (chapter.getTitle() != null) {
            this.transKeys.put(prefix + ".title", HandlerCounter.addPercent(chapter.getRawTitle()));
            chapter.setRawTitle("{" + prefix + ".title}");
        }
        if (!chapter.getRawSubtitle().isEmpty()) {
            int num = 0;
            try {
                Field rawSubtitle = chapter.getClass().getDeclaredField("rawSubtitle");
                rawSubtitle.setAccessible(true);
                ArrayList subtitle = new ArrayList(chapter.getRawSubtitle());
                ArrayList<CallSite> rawSubList = new ArrayList<CallSite>();
                for (String s : subtitle) {
                    String key = prefix + ".subtitle" + num;
                    this.transKeys.put(key, HandlerCounter.addPercent(s));
                    rawSubList.add((CallSite)((Object)("{" + key + "}")));
                    rawSubtitle.set(chapter, rawSubList);
                    ++num;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Narrator.LOGGER.info(e.getMessage());
            }
        }
        ArrayList images = new ArrayList(chapter.getImages());
        for (ChapterImage image : images) {
            try {
                Field hoverText = ChapterImage.class.getDeclaredField("hover");
                hoverText.setAccessible(true);
                ArrayList hoverTextList = new ArrayList((List)hoverText.get(image));
                ArrayList chapterImageHoverTextList = new ArrayList();
                if (hoverTextList.isEmpty()) continue;
                hoverTextList.forEach(hoverTextString -> {
                    HandlerCounter.addImageNum();
                    String key = prefix + ".image.hovertext" + HandlerCounter.getImageNum();
                    this.transKeys.put(key, HandlerCounter.addPercent(hoverTextString));
                    chapterImageHoverTextList.add(key);
                });
                hoverText.set(image, chapterImageHoverTextList);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Narrator.LOGGER.info(e.getMessage());
            }
        }
        HandlerCounter.setImageNum(0);
    }

    private void handleTasks(List<Task> tasks) {
        tasks.stream().filter(task -> !task.getRawTitle().isEmpty()).forEach(task -> {
            HandlerCounter.addCounter();
            String textKey = HandlerCounter.getPrefix() + ".task." + task.id + ".title";
            this.transKeys.put(textKey, HandlerCounter.addPercent(task.getRawTitle()));
            task.setRawTitle("{" + textKey + "}");
        });
        HandlerCounter.setCounter(0);
    }

    private void handleRewards(List<Reward> rewards) {
        rewards.stream().filter(reward -> !reward.getRawTitle().isEmpty()).forEach(reward -> {
            HandlerCounter.addCounter();
            String textKey = HandlerCounter.getPrefix() + ".reward." + reward.id + ".title";
            this.transKeys.put(textKey, HandlerCounter.addPercent(reward.getRawTitle()));
            reward.setRawTitle("{" + textKey + "}");
        });
        HandlerCounter.setCounter(0);
    }

    @Override
    public void handleQuests(List<Quest> allQuests) {
        allQuests.forEach(quest -> {
            HandlerCounter.addQuests();
            HandlerCounter.setPrefix("ftbquests.chapter." + quest.getChapter().getFilename() + ".quest" + quest.id);
            String prefix = HandlerCounter.getPrefix();
            if (quest.getTitle() != null && !quest.getRawTitle().isEmpty()) {
                this.transKeys.put(prefix + ".title", HandlerCounter.addPercent(quest.getRawTitle()));
                quest.setRawTitle("{" + prefix + ".title}");
            }
            if (!quest.getRawSubtitle().isEmpty()) {
                this.transKeys.put(prefix + ".subtitle", HandlerCounter.addPercent(quest.getRawSubtitle()));
                quest.setRawSubtitle("{" + prefix + ".subtitle}");
            }
            this.handleTasks(quest.getTasksAsList());
            this.handleRewards(quest.getRewards().stream().toList());
            this.handleQuestDescriptions(quest.getRawDescription());
            quest.getRawDescription().clear();
            quest.getRawDescription().addAll(HandlerCounter.descList);
            HandlerCounter.descList.clear();
        });
        HandlerCounter.setQuests(0);
    }

    private void handleQuestDescriptions(List<String> descriptions) {
        String rich_desc_regex = "\\s*[\\[\\{].*\"+.*[\\]\\}]\\s*";
        Pattern rich_desc_pattern = Pattern.compile(rich_desc_regex);
        descriptions.forEach(desc -> {
            if (desc.isBlank()) {
                HandlerCounter.descList.add("");
            } else if (desc.contains("{image:")) {
                this.handleDescriptionImage((String)desc);
            } else if (desc.contains("{@pagebreak}")) {
                HandlerCounter.descList.add((String)desc);
            } else if (rich_desc_pattern.matcher((CharSequence)desc).find()) {
                HandlerCounter.addDescription();
                Component parsedText = TextUtils.parseRawText((String)desc);
                HandlerCounter.descList.add(this.handleJSON.handleJSON(parsedText));
            } else {
                HandlerCounter.addDescription();
                String textKey = HandlerCounter.getPrefix() + ".description" + HandlerCounter.getDescription();
                this.transKeys.put(textKey, HandlerCounter.addPercent(desc));
                HandlerCounter.descList.add("{" + textKey + "}");
            }
        });
        HandlerCounter.setDescription(0);
        HandlerCounter.setImage(0);
    }

    private void handleDescriptionImage(String desc) {
        String imgKey = HandlerCounter.getPrefix() + ".image" + HandlerCounter.getImage();
        this.transKeys.put(imgKey, HandlerCounter.addPercent(desc));
        HandlerCounter.descList.add("{" + imgKey + "}");
        HandlerCounter.addImage();
    }
}

