/*
 * Decompiled with CFR 0.152.
 */
package me.litchi.ftbqlocal.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import me.litchi.ftbqlocal.FtbQuestLocalizerMod;
import me.litchi.ftbqlocal.handler.impl.Handler;
import me.litchi.ftbqlocal.utils.BackPortUtils;
import me.litchi.ftbqlocal.utils.Constants;
import me.litchi.ftbqlocal.utils.HandlerCounter;
import me.litchi.ftbqlocal.utils.PackUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class FTBQLangConvert {
    public static String originalLangCode = "en_us";
    private static final String[] langList = new String[]{"en_us", "zh_cn", "zh_tw", "zh_hk", "de_de", "es_es", "fr_fr", "ja_jp", "ko_kr", "ru_ru"};

    public FTBQLangConvert(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ftblang").then(Commands.m_82127_((String)"export").then(Commands.m_82129_((String)"originalLangCode", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            try {
                File output2 = new File(Constants.PackMCMeta.GAMEDIR, "config\\ftbquests\\quests\\");
                File parent = new File(Constants.PackMCMeta.GAMEDIR, "FTBLang");
                File kubejsOutput = new File(parent, "kubejs\\assets\\ftbquestlocalizer\\lang\\");
                File kubejsBackupFile = new File(parent, "backup\\kubejs\\assets\\ftbquestlocalizer\\lang\\");
                File mcKubeJsOut = new File("kubejs\\assets\\ftbquestlocalizer\\lang\\");
                File questsFolder = new File(Constants.PackMCMeta.GAMEDIR, "config\\ftbquests\\quests\\");
                originalLangCode = (String)ctx.getArgument("originalLangCode", String.class);
                for (String langStr : langList) {
                    ServerQuestFile serverQuestFile = ServerQuestFile.INSTANCE;
                    serverQuestFile.markDirty();
                    serverQuestFile.saveNow();
                    Handler handler = new Handler();
                    if (mcKubeJsOut.exists()) {
                        FileUtils.copyDirectory((File)mcKubeJsOut, (File)kubejsBackupFile);
                    }
                    BackPortUtils.backport(langStr);
                    BaseQuestFile questFile = FTBQuestsAPI.api().getQuestFile(false);
                    handler.handleRewardTables(questFile.getRewardTables());
                    questFile.forAllChapterGroups(handler::handleChapterGroup);
                    HandlerCounter.setCounter(0);
                    questFile.forAllChapters(chapter -> {
                        handler.handleChapter((Chapter)chapter);
                        handler.handleQuests(chapter.getQuests());
                        HandlerCounter.addChapters();
                    });
                    File output = new File(parent, "config\\ftbquests\\quests\\");
                    questFile.writeDataFull(output.toPath());
                    questFile.writeDataFull(output2.toPath());
                    ServerQuestFile.INSTANCE.load();
                    this.saveLang(langStr, kubejsOutput);
                    this.saveLang(langStr, mcKubeJsOut);
                }
                ((CommandSourceStack)ctx.getSource()).m_81375_().m_5661_((Component)Component.m_237113_((String)("FTB quests files exported to: " + parent.getAbsolutePath())), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 1;
        }))));
    }

    private void saveLang(String lang, File parent) throws IOException {
        File fe = new File(parent, lang.toLowerCase(Locale.ROOT) + ".json");
        FileUtils.write((File)fe, (CharSequence)FtbQuestLocalizerMod.gson.toJson(HandlerCounter.transKeys), (Charset)StandardCharsets.UTF_8);
        PackUtils.createResourcePack(parent, FMLPaths.GAMEDIR.get().toFile() + "\\FTBLang\\FTB-Quests-Localization-Resourcepack.zip");
    }
}

