/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.compat.jei;

import com.oierbravo.create_mechanical_spawner.CreateMechanicalSpawner;
import com.oierbravo.create_mechanical_spawner.compat.jei.SpawnerCategory;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.foundation.utility.ModLang;
import com.oierbravo.create_mechanical_spawner.registrate.ModBlocks;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CreateMechanicalSpawnerJEI
implements IModPlugin {
    private static final ResourceLocation ID = CreateMechanicalSpawner.asResource("jei_plugin");
    public IIngredientManager ingredientManager;
    private final List<CreateRecipeCategory<?>> modCategories = new ArrayList();

    private void loadCategories() {
        this.modCategories.clear();
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List spawnRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)SpawnerRecipe.Type.INSTANCE);
        CreateRecipeCategory<SpawnerRecipe> spawn = this.builder(SpawnerRecipe.class).addRecipes(spawnRecipes).catalyst(() -> ModBlocks.MECHANICAL_SPAWNER.get()).emptyBackground(177, 75).build("spawner", (CreateRecipeCategory.Factory<SpawnerRecipe>)((CreateRecipeCategory.Factory)SpawnerCategory::new));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.modCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.modCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.modCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<SpawnerRecipe>>> recipeListConsumers = new ArrayList<Consumer<List<SpawnerRecipe>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<SpawnerRecipe>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Collection<SpawnerRecipe> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll(collection));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer<List<SpawnerRecipe>> consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(CreateMechanicalSpawner.asResource(name), this.recipeClass), (Component)ModLang.translate("recipe." + name, new Object[0]).component(), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            CreateMechanicalSpawnerJEI.this.modCategories.add(category);
            return category;
        }
    }
}

