/*
 * Decompiled with CFR 0.152.
 */
package com.landscapesreimagined.createbiggerstoragetocreate6.preinitutils;

import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class LookAroundMatchers {
    public static boolean lookAhead(Matcher matcher, AbstractInsnNode insn, MethodNode method, ClassNode targetClass) {
        int pos = 0;
        AbstractInsnNode current = insn;
        while (!matcher.done(current, pos)) {
            if (current.getNext() == null) {
                return false;
            }
            if (!matcher.match(current, pos)) {
                return false;
            }
            current = current.getNext();
            ++pos;
        }
        return true;
    }

    public static interface Matcher {
        public boolean match(AbstractInsnNode var1, int var2);

        public boolean done(AbstractInsnNode var1, int var2);
    }

    public static class SimpleOpcodeMatcher
    implements Matcher {
        ArrayList<Integer> opcodes;
        final int length;

        public SimpleOpcodeMatcher(int length, int ... opcodes) {
            this.length = length;
            this.opcodes = Arrays.stream(opcodes).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        }

        @Override
        public boolean match(AbstractInsnNode instruction, int position) {
            return instruction.getOpcode() == this.opcodes.get(position).intValue();
        }

        @Override
        public boolean done(AbstractInsnNode instruction, int position) {
            return position >= this.length;
        }
    }
}

