/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.utils.Size;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="border_texture", group="texture")
public class ResourceBorderTexture
extends ResourceTexture {
    public static final ResourceBorderTexture BORDERED_BACKGROUND = new ResourceBorderTexture("ldlib:textures/gui/background.png", 16, 16, 4, 4);
    public static final ResourceBorderTexture BORDERED_BACKGROUND_INVERSE = new ResourceBorderTexture("ldlib:textures/gui/background_inverse.png", 16, 16, 4, 4);
    public static final ResourceBorderTexture BORDERED_BACKGROUND_BLUE = new ResourceBorderTexture("ldlib:textures/gui/bordered_background_blue.png", 195, 136, 4, 4);
    public static final ResourceBorderTexture BUTTON_COMMON = new ResourceBorderTexture("ldlib:textures/gui/button.png", 32, 32, 2, 2);
    public static final ResourceBorderTexture BAR = new ResourceBorderTexture("ldlib:textures/gui/button_common.png", 180, 20, 1, 1);
    public static final ResourceBorderTexture SELECTED = new ResourceBorderTexture("ldlib:textures/gui/selected.png", 16, 16, 2, 2);
    @Configurable(tips={"ldlib.gui.editor.tips.corner_size.0", "ldlib.gui.editor.tips.corner_size.1"}, collapse=false)
    public Size borderSize;
    @Configurable(tips={"ldlib.gui.editor.tips.image_size"}, collapse=false)
    public Size imageSize;

    public ResourceBorderTexture() {
        this("ldlib:textures/gui/bordered_background_blue.png", 195, 136, 4, 4);
    }

    public ResourceBorderTexture(String imageLocation, int imageWidth, int imageHeight, int cornerWidth, int cornerHeight) {
        super(imageLocation);
        this.borderSize = new Size(cornerWidth, cornerHeight);
        this.imageSize = new Size(imageWidth, imageHeight);
    }

    public ResourceBorderTexture setBorderSize(int width, int height) {
        this.borderSize = new Size(width, height);
        return this;
    }

    public ResourceBorderTexture setImageSize(int width, int height) {
        this.imageSize = new Size(width, height);
        return this;
    }

    @Override
    public ResourceTexture copy() {
        return new ResourceBorderTexture(this.imageLocation.toString(), this.imageSize.width, this.imageSize.height, this.borderSize.width, this.borderSize.height);
    }

    @Override
    public ResourceBorderTexture setColor(int color) {
        super.setColor(color);
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawSubAreaInternal(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        float cornerWidth = (float)this.borderSize.width * 1.0f / (float)this.imageSize.width;
        float cornerHeight = (float)this.borderSize.height * 1.0f / (float)this.imageSize.height;
        super.drawSubAreaInternal(graphics, x, y, this.borderSize.width, this.borderSize.height, 0.0f, 0.0f, cornerWidth, cornerHeight);
        super.drawSubAreaInternal(graphics, x + width - (float)this.borderSize.width, y, this.borderSize.width, this.borderSize.height, 1.0f - cornerWidth, 0.0f, cornerWidth, cornerHeight);
        super.drawSubAreaInternal(graphics, x, y + height - (float)this.borderSize.height, this.borderSize.width, this.borderSize.height, 0.0f, 1.0f - cornerHeight, cornerWidth, cornerHeight);
        super.drawSubAreaInternal(graphics, x + width - (float)this.borderSize.width, y + height - (float)this.borderSize.height, this.borderSize.width, this.borderSize.height, 1.0f - cornerWidth, 1.0f - cornerHeight, cornerWidth, cornerHeight);
        super.drawSubAreaInternal(graphics, x + (float)this.borderSize.width, y, width - (float)(2 * this.borderSize.width), this.borderSize.height, cornerWidth, 0.0f, 1.0f - 2.0f * cornerWidth, cornerHeight);
        super.drawSubAreaInternal(graphics, x + (float)this.borderSize.width, y + height - (float)this.borderSize.height, width - (float)(2 * this.borderSize.width), this.borderSize.height, cornerWidth, 1.0f - cornerHeight, 1.0f - 2.0f * cornerWidth, cornerHeight);
        super.drawSubAreaInternal(graphics, x, y + (float)this.borderSize.height, this.borderSize.width, height - (float)(2 * this.borderSize.height), 0.0f, cornerHeight, cornerWidth, 1.0f - 2.0f * cornerHeight);
        super.drawSubAreaInternal(graphics, x + width - (float)this.borderSize.width, y + (float)this.borderSize.height, this.borderSize.width, height - (float)(2 * this.borderSize.height), 1.0f - cornerWidth, cornerHeight, cornerWidth, 1.0f - 2.0f * cornerHeight);
        super.drawSubAreaInternal(graphics, x + (float)this.borderSize.width, y + (float)this.borderSize.height, width - (float)(2 * this.borderSize.width), height - (float)(2 * this.borderSize.height), cornerWidth, cornerHeight, 1.0f - 2.0f * cornerWidth, 1.0f - 2.0f * cornerHeight);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawGuides(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        new ColorBorderTexture(-1, -65536).draw(graphics, 0, 0, x + (float)width * this.offsetX, y + (float)height * this.offsetY, (int)((float)width * this.imageWidth), (int)((float)height * this.imageHeight));
        float cornerWidth = (float)this.borderSize.width * 1.0f / (float)this.imageSize.width;
        float cornerHeight = (float)this.borderSize.height * 1.0f / (float)this.imageSize.height;
        new ColorBorderTexture(-1, -16711936).draw(graphics, 0, 0, x, y, (int)((float)width * cornerWidth), (int)((float)height * cornerHeight));
    }
}

