/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.item;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@LDLRegister(name="give player item", group="graph_processor.node.minecraft.item")
public class GivePlayerItemNode
extends LinearTriggerNode {
    @InputPort
    public Object target;
    @InputPort
    public ItemStack itemstack;
    @InputPort(name="preferred slot", tips={"If the inventory can't hold it, the item will be dropped in the world at the players position."})
    public Integer preferredSlot;
    @Configurable(name="preferred slot")
    public int internalPreferredSlot;

    @Override
    public void process() {
        Object object = this.target;
        if (object instanceof Player) {
            Player player = (Player)object;
            if (this.itemstack != null) {
                ItemTransferHelper.giveItemToPlayer(player, this.itemstack, this.preferredSlot == null ? this.internalPreferredSlot : this.preferredSlot);
            }
        }
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        Class<?> clazz = this.getClass();
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("preferredSlot") || !port.getEdges().isEmpty()) continue;
            try {
                ConfiguratorParser.createFieldConfigurator(clazz.getField("internalPreferredSlot"), father, clazz, new HashMap<String, Method>(), this);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

