/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.logic;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import java.util.function.BiPredicate;

@LDLRegister(name="comparator", group="graph_processor.node.logic")
public class ComparatorNode
extends BaseNode {
    @InputPort
    public float a = 0.0f;
    @InputPort
    public float b = 0.0f;
    @OutputPort
    public boolean out;
    @Configurable(showName=false)
    public ComparatorType type = ComparatorType.EQUAL;

    @Override
    public void process() {
        this.out = this.type.predicate.test(Float.valueOf(this.a), Float.valueOf(this.b));
    }

    public static enum ComparatorType {
        EQUAL(Float::equals),
        NOT_EQUAL((a, b) -> !a.equals(b)),
        GREATER((a, b) -> a.floatValue() > b.floatValue()),
        GREATER_EQUAL((a, b) -> a.floatValue() >= b.floatValue()),
        LESS((a, b) -> a.floatValue() < b.floatValue()),
        LESS_EQUAL((a, b) -> a.floatValue() <= b.floatValue());

        public final BiPredicate<Float, Float> predicate;

        private ComparatorType(BiPredicate<Float, Float> predicate) {
            this.predicate = predicate;
        }
    }
}

