/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.menu;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MenuTab
implements ILDLRegister {
    private static final Map<String, List<BiConsumer<MenuTab, TreeBuilder.Menu>>> HOOKS = new LinkedHashMap<String, List<BiConsumer<MenuTab, TreeBuilder.Menu>>>();
    protected Editor editor = Editor.INSTANCE;

    protected MenuTab() {
        if (this.editor == null) {
            throw new RuntimeException("editor is null while creating a menu tab %s".formatted(this.name()));
        }
    }

    public static void registerMenuHook(String menuName, BiConsumer<MenuTab, TreeBuilder.Menu> consumer) {
        HOOKS.computeIfAbsent(menuName, n -> new ArrayList()).add(consumer);
    }

    public TreeBuilder.Menu appendMenu(TreeBuilder.Menu menu) {
        for (BiConsumer hook : HOOKS.getOrDefault(this.name(), Collections.emptyList())) {
            hook.accept(this, menu);
        }
        return menu;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Widget createTabWidget() {
        int width = Minecraft.m_91087_().f_91062_.m_92895_(LocalizationUtils.format(this.getTranslateKey(), new Object[0]));
        ButtonWidget button = new ButtonWidget(0, 0, width + 6, 16, new TextTexture(this.getTranslateKey()), null).setHoverTexture(ColorPattern.T_WHITE.rectTexture(), new TextTexture(this.getTranslateKey()));
        button.setOnPressCallback(cd -> {
            Position pos = button.getPosition();
            TreeBuilder.Menu view = this.createMenu();
            if (view != null) {
                IProject currentProject = this.editor.getCurrentProject();
                if (currentProject != null) {
                    currentProject.attachMenu(this.editor, this.name(), view);
                }
                this.editor.openMenu((double)pos.x, (double)(pos.y + 14), this.appendMenu(view));
            }
        });
        return button.setClientSideWidget();
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    @Nullable
    protected abstract TreeBuilder.Menu createMenu();
}

