/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.accessors;

import com.lowdragmc.lowdraglib.gui.editor.accessors.IConfiguratorAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CollectionConfiguratorAccessor
implements IConfiguratorAccessor<Collection> {
    private final Class<?> baseType;
    private final Class<?> childType;
    private final IConfiguratorAccessor childAccessor;

    @Override
    public boolean test(Class<?> type) {
        return type.isArray();
    }

    @Override
    public Collection defaultValue(Field field, Class<?> type) {
        if (type == List.class) {
            return new ArrayList();
        }
        if (type == Set.class) {
            return new HashSet();
        }
        return new ArrayList();
    }

    @Override
    public Configurator create(String name, Supplier<Collection> supplier, Consumer<Collection> consumer, boolean forceUpdate, Field field) {
        boolean isCollapse = true;
        boolean canCollapse = true;
        if (field.isAnnotationPresent(Configurable.class)) {
            isCollapse = field.getAnnotation(Configurable.class).collapse();
            canCollapse = field.getAnnotation(Configurable.class).canCollapse();
        }
        ArrayConfiguratorGroup<Object> arrayGroup = new ArrayConfiguratorGroup<Object>(name, isCollapse, () -> {
            Object collection = (Collection)supplier.get();
            if (collection == null) {
                collection = this.defaultValue(field, (Class)this.baseType);
            }
            ArrayList objectList = new ArrayList(collection);
            return objectList;
        }, (getter, setter) -> this.childAccessor.create("", getter, setter, forceUpdate, field), forceUpdate);
        arrayGroup.setAddDefault(() -> this.childAccessor.defaultValue(field, this.childType));
        arrayGroup.setOnUpdate(list -> consumer.accept(this.updateCollection((Collection)supplier.get(), (List<Object>)list)));
        arrayGroup.setCanCollapse(canCollapse);
        arrayGroup.setOnReorder((index, widget) -> arrayGroup.notifyListUpdate());
        return arrayGroup;
    }

    public Collection updateCollection(Collection base, List<Object> objectList) {
        base.clear();
        base.addAll(objectList);
        return base;
    }

    public CollectionConfiguratorAccessor(Class<?> baseType, Class<?> childType, IConfiguratorAccessor childAccessor) {
        this.baseType = baseType;
        this.childType = childType;
        this.childAccessor = childAccessor;
    }
}

