/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.entry;

import com.simibubi.create.foundation.particle.ICustomParticleData;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.forsteri.ratatouille.content.spreader.SpreaderParticleData;
import org.forsteri.ratatouille.util.Lang;

public enum CRParticleTypes {
    SPREADER(SpreaderParticleData::new);

    private final ParticleEntry<?> entry;

    private <D extends ParticleOptions> CRParticleTypes(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        String name = Lang.asId(this.name());
        this.entry = new ParticleEntry(name, typeFactory);
    }

    public static void register(IEventBus modEventBus) {
        ParticleEntry.REGISTER.register(modEventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        for (CRParticleTypes particle : CRParticleTypes.values()) {
            particle.entry.registerFactory(event);
        }
    }

    public ParticleType<?> get() {
        return (ParticleType)this.entry.object.get();
    }

    public String parameter() {
        return this.entry.name;
    }

    private static class ParticleEntry<D extends ParticleOptions> {
        private static final DeferredRegister<ParticleType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"ratatouille");
        private final String name;
        private final Supplier<? extends ICustomParticleData<D>> typeFactory;
        private final RegistryObject<ParticleType<D>> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = REGISTER.register(name, () -> this.typeFactory.get().createType());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(RegisterParticleProvidersEvent event) {
            this.typeFactory.get().register((ParticleType)this.object.get(), event);
        }
    }
}

