/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.squeeze_basin;

import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlockEntity;
import org.forsteri.ratatouille.entry.CRPartialModels;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SqueezeBasinVisual
extends AbstractBlockEntityVisual<SqueezeBasinBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance cover = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)CRPartialModels.SQUEEZE_BASIN_COVER)).createInstance();

    public SqueezeBasinVisual(VisualizationContext context, SqueezeBasinBlockEntity blockEntity, float partialTick) {
        super(context, (BlockEntity)blockEntity, partialTick);
        Quaternionf q = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(MechanicalPressBlock.HORIZONTAL_FACING))));
        this.cover.rotation((Quaternionfc)q);
        this.transformModels();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset((SqueezeBasinBlockEntity)this.blockEntity);
        this.cover.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(SqueezeBasinBlockEntity be) {
        if (be.getOperator().isEmpty()) {
            return 0.0f;
        }
        PressingBehaviour pressingBehaviour = be.getOperator().get().getPressingBehaviour();
        float offset = pressingBehaviour.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks()) * pressingBehaviour.mode.headOffset - 1.0f;
        return Math.max(0.0f, offset);
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.cover});
    }

    protected void _delete() {
        this.cover.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.cover);
    }
}

