/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.squeeze_basin;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlock;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinInventory;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezingRecipe;
import org.forsteri.ratatouille.entry.CRItems;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class SqueezeBasinBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SqueezeBasinInventory inputInventory = new SqueezeBasinInventory(1, this);
    public SmartFluidTankBehaviour inputTank;
    public SqueezingRecipe lastRecipe;
    protected SmartInventory outputInventory;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected LazyOptional<IFluidHandler> fluidCapability;
    int recipeBackupCheck;
    private boolean contentsChanged;

    public SqueezeBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        }).withMaxStackSize(64);
        this.outputInventory = new SqueezeBasinInventory(1, this).forbidInsertion().withMaxStackSize(64);
        this.itemCapability = LazyOptional.of(() -> new SqueezeBasinInventoryHandler());
        this.contentsChanged = true;
        this.recipeBackupCheck = 20;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)inputCap.orElse(null)});
        });
    }

    public void tick() {
        super.tick();
        if (!this.outputInventory.m_7983_() && !this.f_58857_.f_46443_) {
            this.tryClearingSpoutputOverflow();
        }
        if (this.contentsChanged) {
            this.contentsChanged = false;
        }
        if (this.getOperator().isEmpty() || this.getProcessingSpeed() == 0.0f || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.outputInventory.m_7983_()) {
            return;
        }
        PressingBehaviour behaviour = this.getOperator().get().getPressingBehaviour();
        if (behaviour.runningTicks == 120) {
            this.process();
        }
        if (behaviour.running) {
            return;
        }
        if (this.inputInventory.getStackInSlot(0).m_41619_() && this.inputTank.isEmpty()) {
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.match(this, (Boolean)this.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING))) {
            Optional recipe = CRRecipeTypes.SQUEEZING.find(this.inputInventory, this.f_58857_);
            if (!recipe.isEmpty()) {
                this.lastRecipe = (SqueezingRecipe)((Object)recipe.get());
                if (this.lastRecipe.match(this, (Boolean)this.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING))) {
                    this.getOperator().ifPresent(be -> be.pressingBehaviour.start(PressingBehaviour.Mode.BASIN));
                }
            }
            this.sendData();
        } else {
            if (this.lastRecipe.match(this, (Boolean)this.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING))) {
                this.getOperator().ifPresent(be -> be.pressingBehaviour.start(PressingBehaviour.Mode.BASIN));
            }
            this.sendData();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_ && this.recipeBackupCheck-- <= 0) {
            this.recipeBackupCheck = 20;
            if (!this.isEmpty()) {
                this.notifyChangeOfContents();
            }
        }
    }

    public boolean isEmpty() {
        return this.inputInventory.m_7983_() && this.outputInventory.m_7983_();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
    }

    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
    }

    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInventory);
        if (((Boolean)this.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING)).booleanValue()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)new ItemStack((ItemLike)CRItems.SAUSAGE_CASING.get(), 1));
        }
    }

    public void onEmptied() {
        this.getOperator().ifPresent(be -> {
            be.basinRemoved = true;
        });
    }

    private void tryClearingSpoutputOverflow() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof SqueezeBasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)SqueezeBasinBlock.f_54117_);
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction.m_122424_()));
        InvManipulationBehaviour inserter = null;
        if (be != null) {
            inserter = (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
        }
        IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack itemStack = this.outputInventory.getStackInSlot(i);
            if (targetInv == null || !ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack, (boolean)true).m_41619_()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)false);
            this.outputInventory.setStackInSlot(i, ItemStack.f_41583_);
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public Optional<MechanicalPressBlockEntity> getOperator() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_6630_(2));
        return be instanceof MechanicalPressBlockEntity ? Optional.of((MechanicalPressBlockEntity)be) : Optional.empty();
    }

    public float getProcessingSpeed() {
        if (this.getOperator().isPresent()) {
            MechanicalPressBlockEntity be = this.getOperator().get();
            return be.pressingBehaviour.getRunningTickSpeed();
        }
        return 0.0f;
    }

    private void process() {
        boolean useCasing;
        if (this.lastRecipe == null || !this.lastRecipe.match(this, (Boolean)this.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING))) {
            Optional recipe = CRRecipeTypes.SQUEEZING.find(this.inputInventory, this.f_58857_);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (SqueezingRecipe)((Object)recipe.get());
        }
        if ((useCasing = this.lastRecipe.useCasing()) != (Boolean)this.m_58900_().m_61143_((Property)SqueezeBasinBlock.CASING)) {
            return;
        }
        if (useCasing) {
            this.m_58904_().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(false)));
        }
        if (!this.lastRecipe.getFluidIngredients().isEmpty()) {
            this.fluidCapability.ifPresent(handler -> handler.drain(((FluidIngredient)this.lastRecipe.getFluidIngredients().get(0)).getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE));
        }
        ItemStack stackInSlot = this.inputInventory.getStackInSlot(0);
        stackInSlot.m_41774_(1);
        this.inputInventory.setStackInSlot(0, stackInSlot);
        this.acceptOutputs(this.lastRecipe.rollResults(), false);
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, boolean simulate) {
        this.outputInventory.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, simulate);
        this.outputInventory.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof SqueezeBasinBlock)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        SmartInventory targetInv = this.outputInventory;
        if (targetInv == null) {
            return false;
        }
        return this.acceptItemOutputsIntoBasin(outputItems, simulate, (IItemHandler)targetInv);
    }

    private boolean acceptItemOutputsIntoBasin(@NotNull List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.goggles.squeeze_basin_contents", new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            Lang.text("").add(Component.m_237115_((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(Lang.text(" x" + stackInSlot.m_41613_()).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = Lang.translate("generic.unit.millibuckets", new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.text("").add(Lang.fluidName(fluidStack).add(Lang.text(" ")).style(ChatFormatting.GRAY).add(Lang.number(fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        Lang.text("").add(Component.m_237115_((String)((Item)CRItems.SAUSAGE_CASING.get()).m_5524_()).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip, 1);
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    private class SqueezeBasinInventoryHandler
    extends CombinedInvWrapper {
        public SqueezeBasinInventoryHandler() {
            super(new IItemHandlerModifiable[]{SqueezeBasinBlockEntity.this.inputInventory, SqueezeBasinBlockEntity.this.outputInventory});
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (SqueezeBasinBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (SqueezeBasinBlockEntity.this.inputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (SqueezeBasinBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    }
}

