/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.oven.BakeData;
import org.forsteri.ratatouille.content.oven.BakingRecipe;
import org.forsteri.ratatouille.content.oven.OvenBlock;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer {
    public LazyOptional<CombinedInvWrapper> itemCapability = LazyOptional.empty();
    public List<List<List<Inventory>>> inventories = null;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected BakeData bakeData;
    protected Inventory inventory = new Inventory();
    protected int height = 1;
    protected int radius = 1;
    private boolean updateConnectivity = false;

    public OvenBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.bakeData = new BakeData();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        super.initialize();
        this.notifyUpdate();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void tick() {
        super.tick();
        if (this.isController()) {
            this.bakeData.tick(this);
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_)) {
            this.removeController(true);
            this.lastKnownPos = this.f_58858_;
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public void updateConnectivity() {
        assert (this.f_58857_ != null);
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Height", this.height);
        }
        super.write(compound, clientPacket);
        compound.m_128359_("StorageType", "CombinedInv");
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        this.bakeData.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        assert (this.f_58857_ != null);
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevHeight = this.height;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
        }
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.bakeData.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.m_58898_() && (changeOfController || prevSize != this.radius || prevHeight != this.height)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    public OvenBlockEntity getControllerBE() {
        assert (this.f_58857_ != null);
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof OvenBlockEntity) {
            OvenBlockEntity ovenBlockEntity = (OvenBlockEntity)blockEntity;
            return ovenBlockEntity;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.equals((Object)this.controller);
    }

    public void setController(BlockPos pos) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (pos.equals((Object)this.controller)) {
            return;
        }
        this.controller = pos;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        this.itemCapability.invalidate();
    }

    public void removeController(boolean keepContents) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.height = 1;
        this.itemCapability.invalidate();
        this.bakeData.clear();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)OvenBlock.IS_2x2, (Comparable)Boolean.valueOf(this.getWidth() == 2)), 6);
        this.itemCapability.invalidate();
        this.updateOvenState();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 7;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        OvenBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return controllerBE.bakeData.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getTotalOvenSize());
    }

    public int getTotalOvenSize() {
        return this.radius * this.radius * this.height;
    }

    public void updateOvenState() {
        if (!this.isController() && this.getControllerBE() != null) {
            this.getControllerBE().updateOvenState();
            return;
        }
        if (this.bakeData.evaluate(this)) {
            this.notifyUpdate();
        }
    }

    public void updateBakeData() {
        OvenBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.bakeData.updateRequired = 2;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void initCapability() {
        assert (this.f_58857_ != null);
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            OvenBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            return;
        }
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.height * this.radius * this.radius];
        this.inventories = new ArrayList<List<List<Inventory>>>();
        for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
            ArrayList x = new ArrayList();
            this.inventories.add(x);
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                ArrayList<Inventory> y = new ArrayList<Inventory>();
                x.add(y);
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    OvenBlockEntity vaultAt = (OvenBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CRBlockEntityTypes.OVEN_ENTITY.get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                    Inventory inv = vaultAt != null ? vaultAt.inventory : new Inventory();
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = inv;
                    y.add(inv);
                }
            }
        }
        CombinedInvWrapper itemHandler = new CombinedInvWrapper(invs);
        this.itemCapability = LazyOptional.of(() -> itemHandler);
    }

    public class Inventory
    extends ItemStackHandler {
        private final RecipeWrapper RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        public int tickTillFinishCooking = -1;
        public Recipe<?> lastRecipe = null;

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            assert (OvenBlockEntity.this.f_58857_ != null);
            ItemStack returnValue = super.insertItem(slot, stack, simulate);
            if (!simulate && returnValue.m_41613_() != stack.m_41613_()) {
                this.RECIPE_WRAPPER.m_6836_(0, this.getStackInSlot(slot));
                Optional bakingOpt = CRRecipeTypes.BAKING.find(this.RECIPE_WRAPPER, OvenBlockEntity.this.f_58857_);
                if (bakingOpt.isPresent()) {
                    BakingRecipe bakingRecipe = (BakingRecipe)((Object)bakingOpt.get());
                    this.tickTillFinishCooking = bakingRecipe.getProcessingDuration() * ((this.getStackInSlot(slot).m_41613_() - 1) / 16 + 1);
                    this.lastRecipe = bakingRecipe;
                    return returnValue;
                }
                Optional smokingOpt = OvenBlockEntity.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44110_, (Container)this.RECIPE_WRAPPER, OvenBlockEntity.this.f_58857_);
                if (smokingOpt.isPresent()) {
                    SmokingRecipe smokingRecipe = (SmokingRecipe)smokingOpt.get();
                    this.tickTillFinishCooking = smokingRecipe.m_43753_() * ((this.getStackInSlot(slot).m_41613_() - 1) / 16 + 1);
                    this.lastRecipe = smokingRecipe;
                }
            }
            return returnValue;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!simulate) {
                this.tickTillFinishCooking = -1;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 16;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            assert (OvenBlockEntity.this.f_58857_ != null);
            this.RECIPE_WRAPPER.m_6836_(0, stack);
            return CRRecipeTypes.BAKING.find(this.RECIPE_WRAPPER, OvenBlockEntity.this.f_58857_).isPresent() || OvenBlockEntity.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44110_, (Container)this.RECIPE_WRAPPER, OvenBlockEntity.this.f_58857_).isPresent();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128405_("tickTillFinishCooking", this.tickTillFinishCooking);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            assert (OvenBlockEntity.this.f_58857_ != null);
            super.deserializeNBT(nbt);
            if (nbt.m_128441_("tickTillFinishCooking")) {
                this.tickTillFinishCooking = nbt.m_128451_("tickTillFinishCooking");
            }
        }

        protected void onContentsChanged(int slot) {
            assert (OvenBlockEntity.this.f_58857_ != null);
            if (!((OvenBlockEntity)OvenBlockEntity.this).f_58857_.f_46443_) {
                OvenBlockEntity.this.m_6596_();
                OvenBlockEntity.this.sendData();
                OvenBlockEntity.this.notifyUpdate();
            }
        }
    }
}

