/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlock;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.jetbrains.annotations.NotNull;

public class CompostTowerBlockItem
extends BlockItem {
    public CompostTowerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult m_40576_(@NotNull BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(@NotNull BlockPos pos, Level level, Player player, @NotNull ItemStack stack, @NotNull BlockState state) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122478_()) {
            return;
        }
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!(placedOnState.m_60734_() instanceof CompostTowerBlock)) {
            return;
        }
        CompostTowerBlockEntity towerAt = (CompostTowerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CRBlockEntityTypes.COMPOST_TOWER_BLOCK_ENTITY.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (towerAt == null) {
            return;
        }
        CompostTowerBlockEntity controllerBE = towerAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.getWidth();
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerBE.m_58899_().m_7495_() : controllerBE.m_58899_().m_6630_(controllerBE.getHeight());
        if (startPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (blockState.m_60734_() instanceof CompostTowerBlock) continue;
                if (!blockState.m_247087_()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (blockState.m_60734_() instanceof CompostTowerBlock) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }
}

