/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.tracking.benefits;

import com.tarinoita.solsweetpotato.tracking.benefits.AttributeBenefit;
import com.tarinoita.solsweetpotato.tracking.benefits.Benefit;
import com.tarinoita.solsweetpotato.tracking.benefits.EffectBenefit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;

public class BenefitList {
    private List<List<Benefit>> benefits;

    public BenefitList(List<List<Benefit>> benefits) {
        this.benefits = benefits;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        int nthresholds = this.benefits.size();
        tag.m_128365_("nthresholds", (Tag)IntTag.m_128679_((int)nthresholds));
        int i = 0;
        for (List<Benefit> thresholdBenefits : this.benefits) {
            int nbenefits = thresholdBenefits.size();
            CompoundTag thresholdTag = new CompoundTag();
            thresholdTag.m_128365_("nbenefits", (Tag)IntTag.m_128679_((int)nbenefits));
            int j = 0;
            for (Benefit b : thresholdBenefits) {
                thresholdTag.m_128365_("benefit_" + j, (Tag)b.serializeNBT());
                ++j;
            }
            tag.m_128365_("threshold_" + i, (Tag)thresholdTag);
            ++i;
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ArrayList<List<Benefit>> newBenefits = new ArrayList<List<Benefit>>();
        int nthresholds = tag.m_128451_("nthresholds");
        for (int i = 0; i < nthresholds; ++i) {
            CompoundTag thresholdTag = tag.m_128469_("threshold_" + i);
            int nbenefits = thresholdTag.m_128451_("nbenefits");
            ArrayList<Benefit> thresholdBenefits = new ArrayList<Benefit>();
            for (int j = 0; j < nbenefits; ++j) {
                CompoundTag benefitTag = thresholdTag.m_128469_("benefit_" + j);
                String benefitType = benefitTag.m_128461_("type");
                if (benefitType.equals("attribute")) {
                    thresholdBenefits.add(AttributeBenefit.fromNBT(benefitTag));
                    continue;
                }
                if (benefitType.equals("effect")) {
                    thresholdBenefits.add(EffectBenefit.fromNBT(benefitTag));
                    continue;
                }
                throw new RuntimeException("Invalid benefit type: " + benefitType);
            }
            newBenefits.add(thresholdBenefits);
        }
        this.benefits = newBenefits;
    }

    public List<List<Benefit>> getBenefits() {
        return this.benefits;
    }
}

