/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootContextType;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class ParamSetTest {
    private static final Vec3 TEST_POS = new Vec3(0.0, 0.0, 0.0);
    private static final BlockPos TEST_BLOCK_POS = new BlockPos(0, 0, 0);

    @GameTest(m_177046_="empty_test_structure")
    public void chest(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.chestContext(helper.m_177100_(), TEST_POS, null);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.CHEST));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void entity(GameTestHelper helper) {
        Cow cow = (Cow)GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), TEST_BLOCK_POS);
        DamageSource ds = cow.m_269291_().m_268989_();
        LootParams params = new LootParams.Builder(helper.m_177100_()).m_287286_(LootContextParams.f_81455_, (Object)cow).m_287286_(LootContextParams.f_81460_, (Object)cow.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)ds).m_287289_(LootContextParams.f_81458_, (Object)ds.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)ds.m_7640_()).m_287235_(LootContextParamSets.f_81415_);
        LootContext ctx = new LootContext.Builder(params).m_287259_(null);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.ENTITY));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void block(GameTestHelper helper) {
        LootParams params = new LootParams.Builder(helper.m_177100_()).m_287286_(LootContextParams.f_81460_, (Object)TEST_POS).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81461_, (Object)helper.m_177100_().m_8055_(TEST_BLOCK_POS)).m_287235_(LootContextParamSets.f_81411_);
        LootContext ctx = new LootContext.Builder(params).m_287259_(null);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.CHEST));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void fishing(GameTestHelper helper) {
        Player player = helper.m_177368_();
        FishingHook martin = new FishingHook(player, (Level)helper.m_177100_(), 0, 0);
        LootParams params = new LootParams.Builder(helper.m_177100_()).m_287286_(LootContextParams.f_81460_, (Object)TEST_POS).m_287286_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_287286_(LootContextParams.f_81455_, (Object)martin).m_287289_(LootContextParams.f_81458_, (Object)player).m_287239_(0.0f).m_287235_(LootContextParamSets.f_81414_);
        LootContext ctx = new LootContext.Builder(params).m_287259_(null);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.FISHING));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void unknown(GameTestHelper helper) {
        LootContextParamSet set = new LootContextParamSet.Builder().m_81406_(LootContextParams.f_81460_).m_81405_();
        LootParams params = new LootParams.Builder(helper.m_177100_()).m_287286_(LootContextParams.f_81460_, (Object)TEST_POS).m_287235_(set);
        LootContext ctx = new LootContext.Builder(params).m_287259_(null);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.UNKNOWN));
    }
}

