/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.forge.client;

import java.nio.file.Path;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.satisfy.vinery.client.VineryClient;
import net.satisfy.vinery.core.entity.DarkCherryBoatEntity;

@Mod.EventBusSubscriber(modid="vinery", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class VineryClientForge {
    @SubscribeEvent
    public static void onClientSetup(RegisterEvent event) {
        VineryClient.preInitClient();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        VineryClient.onInitializeClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path packPath = ModList.get().getModFileById("vinery").getFile().findResource(new String[]{"resourcepacks/bushy_leaves"});
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.m_245429_((String)new ResourceLocation("vinery", "bushy_leaves").toString(), (Component)Component.m_237113_((String)"Bushy Leaves for Vinery"), (boolean)false, id -> new PathPackResources(id, packPath, false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack != null) {
                    consumer.accept(pack);
                }
            });
        }
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (DarkCherryBoatEntity.Type type : DarkCherryBoatEntity.Type.values()) {
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("vinery", type.getModelLocation()), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("vinery", type.getChestModelLocation()), "main"), ChestBoatModel::m_247175_);
        }
    }
}

