/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.ServerLevelData;
import net.satisfy.vinery.core.entity.TraderMuleEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class WanderingTraderManagerMixin
implements CustomSpawner {
    @Shadow
    @Final
    private ServerLevelData f_35909_;

    @Shadow
    @Nullable
    protected abstract BlockPos m_35928_(LevelReader var1, BlockPos var2, int var3);

    @Shadow
    protected abstract boolean m_35925_(BlockGetter var1, BlockPos var2);

    @Inject(method={"spawn"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/entity/EntityType;spawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/MobSpawnType;)Lnet/minecraft/world/entity/Entity;")}, cancellable=true)
    private void trySpawn(ServerLevel world, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer playerEntity;
        if (world.f_46441_.m_188500_() < PlatformHelper.getTraderSpawnChance() && (playerEntity = world.m_8890_()) != null) {
            WanderingTrader wanderingTraderEntity;
            EntityType wanderingWinemakerType;
            Holder biome;
            BlockPos blockPos = playerEntity.m_20183_();
            PoiManager pointOfInterestStorage = world.m_8904_();
            Optional optional = pointOfInterestStorage.m_27186_(type -> type.m_203565_(PoiTypes.f_218061_), pos -> true, blockPos, 48, PoiManager.Occupancy.ANY);
            BlockPos blockPos2 = optional.orElse(blockPos);
            BlockPos blockPos3 = this.m_35928_((LevelReader)world, blockPos2, 48);
            if (blockPos3 != null && this.m_35925_((BlockGetter)world, blockPos3) && (biome = world.m_204166_(blockPos3)) != null && !biome.m_203565_(Biomes.f_48173_) && (wanderingWinemakerType = (EntityType)EntityTypeRegistry.WANDERING_WINEMAKER.get()) != null && (wanderingTraderEntity = (WanderingTrader)wanderingWinemakerType.m_262496_(world, blockPos3, MobSpawnType.EVENT)) != null) {
                if (PlatformHelper.shouldSpawnWithMules()) {
                    for (int j = 0; j < 2; ++j) {
                        TraderMuleEntity traderMuleEntity;
                        EntityType muleType;
                        BlockPos blockPos4 = this.m_35928_((LevelReader)world, wanderingTraderEntity.m_20183_(), 4);
                        if (blockPos4 == null || (muleType = (EntityType)EntityTypeRegistry.MULE.get()) == null || (traderMuleEntity = (TraderMuleEntity)muleType.m_262496_(world, blockPos4, MobSpawnType.EVENT)) == null) continue;
                        traderMuleEntity.m_21463_((Entity)wanderingTraderEntity, true);
                    }
                }
                if (this.f_35909_ != null) {
                    this.f_35909_.m_8115_(wanderingTraderEntity.m_20148_());
                    wanderingTraderEntity.m_35891_(PlatformHelper.getTraderSpawnDelay());
                    wanderingTraderEntity.m_35883_(blockPos2);
                    wanderingTraderEntity.m_21446_(blockPos2, 16);
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

