/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.core.block.BasketBlock;
import net.satisfy.vinery.core.block.entity.BasketBlockEntity;

public class BasketRenderer
implements BlockEntityRenderer<BasketBlockEntity> {
    private static final ResourceLocation TEXTURE = Vinery.identifier("textures/entity/basket.png");
    private final ModelPart lidleft;
    private final ModelPart lidright;
    private final ModelPart bottom;
    private final ModelPart handle;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Vinery.identifier("basket"), "main");

    public BasketRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(LAYER_LOCATION);
        this.bottom = modelPart.m_171324_("bottom");
        this.handle = modelPart.m_171324_("handle");
        this.lidright = modelPart.m_171324_("lidright");
        this.lidleft = modelPart.m_171324_("lidleft");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bottom = partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -20.5f, 3.0f, 12.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)20.5f, (float)0.0f));
        PartDefinition handle = partdefinition.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(2, 22).m_171488_(-2.5f, -7.5f, 7.0f, 12.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 21).m_171480_().m_171488_(9.51f, -15.5f, 7.0f, 0.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 21).m_171480_().m_171488_(-2.51f, -15.5f, 7.0f, 0.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.5f, (float)20.5f, (float)0.0f));
        PartDefinition lidright = partdefinition.m_171599_("lidright", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171480_().m_171488_(2.0f, -19.0f, 3.0f, 12.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition lidleft = partdefinition.m_171599_("lidleft", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171480_().m_171488_(2.0f, -19.0f, 8.0f, 12.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void render(BasketBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockState blockState;
        float g = 0.0f;
        if (blockEntity.m_58898_() && (blockState = Objects.requireNonNull(blockEntity.m_58904_()).m_8055_(blockEntity.m_58899_())).m_60734_() instanceof BasketBlock) {
            g = ((Direction)blockState.m_61143_((Property)BasketBlock.FACING)).m_122435_();
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-g));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        float openNess = blockEntity.m_6683_(f);
        openNess = 1.0f - openNess;
        openNess = 1.0f - openNess * openNess * openNess;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.renderLid(poseStack, vertexConsumer, this.lidleft, openNess, i, j, false);
        this.renderLid(poseStack, vertexConsumer, this.lidright, openNess, i, j, true);
        this.bottom.m_104301_(poseStack, vertexConsumer, i, j);
        this.handle.m_104301_(poseStack, vertexConsumer, i, j);
        this.renderLid(poseStack, vertexConsumer, this.lidleft, openNess, i, j, false);
        this.renderLid(poseStack, vertexConsumer, this.lidright, openNess, i, j, true);
        poseStack.m_85849_();
    }

    private void renderLid(PoseStack poseStack, VertexConsumer vertexConsumer, ModelPart lid, float openNess, int i, int j, boolean isMirrored) {
        float lidRotationAngle = -(openNess * 0.2f);
        float lidVerticalMovement = openNess * -1.8f;
        if (isMirrored) {
            lidRotationAngle = -lidRotationAngle;
            lidVerticalMovement = -lidVerticalMovement;
        }
        lid.f_104203_ = lidRotationAngle;
        lid.f_104201_ += lidVerticalMovement;
        lid.m_104301_(poseStack, vertexConsumer, i, j);
        lid.f_104201_ -= lidVerticalMovement;
    }

    public ModelPart getTop() {
        return this.lidleft;
    }

    public ModelPart getBottom() {
        return this.bottom;
    }
}

