/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.dreadsteel.item.armor;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mindoth.dreadsteel.config.DreadsteelCommonConfig;
import net.mindoth.dreadsteel.item.CosmeticKit;
import net.mindoth.dreadsteel.item.armor.DreadsteelArmor;
import net.mindoth.dreadsteel.registries.DreadsteelItems;
import net.minecraft.Util;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dreadsteel")
public class ArmorEvents {
    public static final Map<String, UUID> NAME_UUID_MAP = new HashMap<String, UUID>();

    public static UUID getUUID(ItemStack stack) {
        return NAME_UUID_MAP.computeIfAbsent(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), s -> UUID.nameUUIDFromBytes(s.getBytes()));
    }

    @SubscribeEvent
    public static void noHat(RenderPlayerEvent event) {
        Player player = event.getEntity();
        if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == DreadsteelItems.DREADSTEEL_HELMET.get()) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102809_.f_104207_ = false;
        }
    }

    @SubscribeEvent
    public static void dreadsteelSetDefence(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() == DreadsteelItems.DREADSTEEL_HELMET.get() && entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == DreadsteelItems.DREADSTEEL_CHESTPLATE.get() && entity.m_6844_(EquipmentSlot.LEGS).m_41720_() == DreadsteelItems.DREADSTEEL_LEGGINGS.get() && entity.m_6844_(EquipmentSlot.FEET).m_41720_() == DreadsteelItems.DREADSTEEL_BOOTS.get() && (event.getSource().m_276093_(DamageTypes.f_268450_) || event.getSource().m_276093_(DamageTypes.f_268631_) || event.getSource().m_276093_(DamageTypes.f_268468_) || event.getSource().m_276093_(DamageTypes.f_268585_))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void dreadsteelAttributeEvent(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item == DreadsteelItems.DREADSTEEL_HELMET.get() && event.getSlotType() == EquipmentSlot.HEAD) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.HELMET_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (item == DreadsteelItems.DREADSTEEL_CHESTPLATE.get() && event.getSlotType() == EquipmentSlot.CHEST) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.CHESTPLATE_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (item == DreadsteelItems.DREADSTEEL_LEGGINGS.get() && event.getSlotType() == EquipmentSlot.LEGS) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.LEGGINGS_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
        if (item == DreadsteelItems.DREADSTEEL_BOOTS.get() && event.getSlotType() == EquipmentSlot.FEET) {
            event.addModifier(Attributes.f_22284_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.BOOTS_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22285_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
            event.addModifier(Attributes.f_22278_, new AttributeModifier(ArmorEvents.getUUID(event.getItemStack()), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onAnvilDyeEvent(AnvilUpdateEvent event) {
        ItemStack leftStack = event.getLeft();
        Item rightItem = event.getRight().m_41720_();
        if (ArmorEvents.isDyeableDreadsteelItem(leftStack.m_41720_())) {
            ItemStack result = leftStack.m_41777_();
            CompoundTag newTag = result.m_41784_();
            if (rightItem instanceof CosmeticKit) {
                if (rightItem == DreadsteelItems.DEFAULT_KIT.get()) {
                    newTag.m_128473_("CustomModelData");
                } else if (rightItem == DreadsteelItems.WHITE_KIT.get()) {
                    newTag.m_128405_("CustomModelData", 1);
                } else if (rightItem == DreadsteelItems.BLACK_KIT.get()) {
                    newTag.m_128405_("CustomModelData", 2);
                } else if (rightItem == DreadsteelItems.BRONZE_KIT.get()) {
                    newTag.m_128405_("CustomModelData", 3);
                }
                ArmorEvents.handleCustomAnvil(event, leftStack, result, newTag);
            }
        }
    }

    private static void handleCustomAnvil(AnvilUpdateEvent event, ItemStack leftStack, ItemStack result, CompoundTag tag) {
        result.m_41751_(tag);
        int xpCost = 1;
        if (event.getName() != null && !Util.m_288217_((String)event.getName())) {
            if (!event.getName().equals(leftStack.m_41786_().getString())) {
                result.m_41714_((Component)Component.m_237113_((String)event.getName()));
                ++xpCost;
            }
        } else if (leftStack.m_41788_()) {
            result.m_41787_();
        }
        event.setMaterialCost(1);
        event.setOutput(result);
        event.setCost(xpCost);
    }

    private static boolean isDyeableDreadsteelItem(Item item) {
        ArmorItem armorItem;
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_().equals((Object)DreadsteelArmor.MaterialDreadsteel.DREADSTEEL) || item == DreadsteelItems.DREADSTEEL_SCYTHE.get() || item == DreadsteelItems.DREADSTEEL_SHIELD.get();
    }
}

