/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.networking.packet;

import java.util.function.Supplier;
import net.acetheeldritchking.art_of_forging.networking.packet.SoulChargedPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SoulChargedParticlesS2CPacket {
    private final double xPos;
    private final double yPos;
    private final double zPos;

    public SoulChargedParticlesS2CPacket(double xPos, double yPos, double zPos) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
    }

    public SoulChargedParticlesS2CPacket(FriendlyByteBuf buf) {
        this.xPos = buf.readDouble();
        this.yPos = buf.readDouble();
        this.zPos = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.xPos);
        buf.writeDouble(this.yPos);
        buf.writeDouble(this.zPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> SoulChargedPacketHandler.doSoulParticles(this.xPos, this.yPos, this.zPos));
        return true;
    }
}

