/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.items.modular.ModularItem;

public class HubrisEffect {
    @SubscribeEvent
    public void onLivingAttackEvent(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack heldStack;
        Item item;
        Entity attackingEntity = event.getSource().m_7639_();
        if (attackingEntity instanceof LivingEntity && (item = (heldStack = (attacker = (LivingEntity)attackingEntity).m_21205_()).m_41720_()) instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            float level = item2.getEffectLevel(heldStack, EffectGuiStats.hubrisEffect);
            float baseAmount = event.getAmount();
            float bonusDamage = EffectGuiStats.getDecimalPercentage(level, baseAmount);
            float BASE_HEALTH = attacker.m_21233_();
            float baseHealth = attacker.m_21223_();
            double percent = baseHealth / BASE_HEALTH * 100.0f;
            if (level > 0.0f) {
                if (percent <= 30.0) {
                    double totalDamage = this.calculateReducedDamageAmount(baseAmount, 2.0);
                    if (Double.isInfinite(totalDamage) || Double.isNaN(totalDamage) || totalDamage <= 0.0) {
                        event.setAmount(baseAmount);
                    } else {
                        event.setAmount((float)totalDamage);
                    }
                } else if (percent <= 40.0) {
                    double totalDamage = this.calculateReducedDamageAmount(baseAmount, 1.5);
                    if (Double.isInfinite(totalDamage) || Double.isNaN(totalDamage) || totalDamage <= 0.0) {
                        event.setAmount(baseAmount);
                    } else {
                        event.setAmount((float)totalDamage);
                    }
                } else if (percent <= 60.0) {
                    event.setAmount(baseAmount);
                } else if (percent <= 70.0) {
                    double totalDamage = this.calculateBonusDamageAmount(baseAmount, bonusDamage, 1.5);
                    if (Double.isInfinite(totalDamage) || Double.isNaN(totalDamage) || totalDamage <= 0.0) {
                        event.setAmount(baseAmount);
                    } else {
                        event.setAmount((float)totalDamage);
                    }
                } else if (percent <= 80.0) {
                    double totalDamage = this.calculateBonusDamageAmount(baseAmount, bonusDamage, 1.0);
                    event.setAmount((float)totalDamage);
                } else {
                    double totalDamage = this.calculateBonusDamageAmount(baseAmount, bonusDamage, 1.0);
                    event.setAmount((float)totalDamage);
                }
            }
        }
    }

    private double calculateBonusDamageAmount(float baseAmount, float bonus, double factor) {
        float totalDamage = (float)((double)baseAmount + (double)bonus / factor);
        return Math.floor(totalDamage);
    }

    private double calculateReducedDamageAmount(float baseAmount, double factor) {
        float totalDamage = (float)((double)baseAmount / factor);
        return Math.floor(totalDamage);
    }
}

