/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.render;

import com.glodblock.github.ae2netanalyser.client.render.NetworkDataHandler;
import com.glodblock.github.ae2netanalyser.common.AEAItems;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.util.ClientUtil;
import com.glodblock.github.ae2netanalyser.util.Util;
import com.glodblock.github.glodium.client.render.ColorData;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class NetworkRender
extends RenderType {
    public static final NetworkRender INSTANCE = new NetworkRender();
    private static final Set<AnalyserMode> renderNodeModes = EnumSet.of(AnalyserMode.NODES, AnalyserMode.FULL, AnalyserMode.NONUM);
    private static final Set<AnalyserMode> renderLinkModes = EnumSet.of(AnalyserMode.CHANNELS, AnalyserMode.FULL, AnalyserMode.NONUM, AnalyserMode.P2P);
    private static ItemStack currentAnalyser;
    private static final ColorData WHITE;
    private static VertexBuffer VBO;
    private final RenderStateShard.TransparencyStateShard STO = new RenderStateShard.TransparencyStateShard("sto", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private final RenderType CUBE_RENDER = NetworkRender.m_173215_((String)"aea_cube", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(this.STO).m_110663_(f_110111_).m_110661_(f_110110_).m_173292_(f_173104_).m_110671_(f_110153_).m_110687_(f_110114_).m_173290_(f_110147_).m_110691_(true));

    public static void hook(RenderLevelStageEvent event) {
        LocalPlayer player;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && (player = Minecraft.m_91087_().f_91074_) != null && player.m_21205_().m_41720_() == AEAItems.ANALYSER) {
            GlobalPos pos;
            if (currentAnalyser != player.m_21205_()) {
                currentAnalyser = player.m_21205_();
                NetworkDataHandler.updateConfig(AEAItems.ANALYSER.getConfig(currentAnalyser));
            }
            if ((pos = AEAItems.ANALYSER.getPos(currentAnalyser)) != null && pos.m_122640_().equals((Object)player.m_9236_().m_46472_())) {
                INSTANCE.tick(event.getPoseStack(), Minecraft.m_91087_().m_91269_().m_110104_(), event.getProjectionMatrix(), event.getCamera());
            }
        }
    }

    public void renderNodes(@NotNull NetworkData data, PoseStack stack, BufferBuilder buf) {
        for (NetworkData.ANode node : data.nodes) {
            ColorData color = NetworkDataHandler.getColorByConfig(node.state().get());
            this.drawCube(NetworkDataHandler.getNodeSize(), color, node.pos(), stack, buf);
        }
    }

    public void renderLinks(@NotNull NetworkData data, PoseStack stack, BufferBuilder buf, boolean p2pOnly) {
        for (NetworkData.ALink link : data.links) {
            LinkFlag flag = link.state().get();
            if (p2pOnly && flag != LinkFlag.COMPRESSED) continue;
            ColorData color = NetworkDataHandler.getColorByConfig(flag);
            this.drawLink(flag == LinkFlag.DENSE, color, link.a().pos(), link.b().pos(), stack, buf);
        }
    }

    public void drawInWorldText(String text, ColorData color, Vec3 pos, Vec3 offset, Camera camera, PoseStack stack, MultiBufferSource multiBuf) {
        float scale = 0.027f;
        Font fontRender = Minecraft.m_91087_().f_91062_;
        Vec3 c = pos.m_82549_(offset);
        float stringMiddle = (float)fontRender.m_92895_(text) / 2.0f;
        stack.m_85836_();
        stack.m_85837_(c.f_82479_, c.f_82480_, c.f_82481_);
        stack.m_252781_(camera.m_253121_());
        stack.m_85841_(-scale, -scale, scale);
        Matrix4f mat = stack.m_85850_().m_252922_();
        fontRender.m_271703_(text, -stringMiddle, 0.0f, color.toARGB(), false, mat, multiBuf, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        stack.m_85849_();
    }

    public void drawCube(float size, ColorData color, BlockPos pos, PoseStack stack, BufferBuilder buf) {
        float half = size / 2.0f;
        Vec3 c = pos.m_252807_();
        AABB box = new AABB(c.f_82479_ - (double)half, c.f_82480_ - (double)half, c.f_82481_ - (double)half, c.f_82479_ + (double)half, c.f_82480_ + (double)half, c.f_82481_ + (double)half);
        Vec3 topRight = new Vec3(box.f_82291_, box.f_82292_, box.f_82293_);
        Vec3 bottomRight = new Vec3(box.f_82291_, box.f_82289_, box.f_82293_);
        Vec3 bottomLeft = new Vec3(box.f_82288_, box.f_82289_, box.f_82293_);
        Vec3 topLeft = new Vec3(box.f_82288_, box.f_82292_, box.f_82293_);
        Vec3 topRight2 = new Vec3(box.f_82291_, box.f_82292_, box.f_82290_);
        Vec3 bottomRight2 = new Vec3(box.f_82291_, box.f_82289_, box.f_82290_);
        Vec3 bottomLeft2 = new Vec3(box.f_82288_, box.f_82289_, box.f_82290_);
        Vec3 topLeft2 = new Vec3(box.f_82288_, box.f_82292_, box.f_82290_);
        this.drawSide(topRight, topLeft, bottomRight, bottomLeft, color, (VertexConsumer)buf, stack);
        this.drawSide(topRight2, topRight, bottomRight2, bottomRight, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, bottomLeft2, bottomRight2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft, topLeft2, bottomLeft, bottomLeft2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, topLeft, topRight, color, (VertexConsumer)buf, stack);
        this.drawSide(bottomLeft2, bottomRight2, bottomLeft, bottomRight, color, (VertexConsumer)buf, stack);
    }

    public void drawLink(boolean isDense, ColorData color, BlockPos from, BlockPos to, PoseStack stack, BufferBuilder buf) {
        Vec3 a = from.m_252807_();
        Vec3 b = to.m_252807_();
        double wide = isDense ? 0.1 : 0.025;
        Vec3 law = ClientUtil.getLawVec(a, b).m_82490_(wide);
        Vec3 law2 = ClientUtil.getLawVec2(a, b).m_82490_(wide);
        Vec3 topRight = a.m_82549_(law2);
        Vec3 bottomRight = a.m_82546_(law);
        Vec3 bottomLeft = a.m_82546_(law2);
        Vec3 topLeft = a.m_82549_(law);
        Vec3 topRight2 = b.m_82549_(law2);
        Vec3 bottomRight2 = b.m_82546_(law);
        Vec3 bottomLeft2 = b.m_82546_(law2);
        Vec3 topLeft2 = b.m_82549_(law);
        this.drawSide(topRight, topLeft, bottomRight, bottomLeft, color, (VertexConsumer)buf, stack);
        this.drawSide(topRight2, topRight, bottomRight2, bottomRight, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, bottomLeft2, bottomRight2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft, topLeft2, bottomLeft, bottomLeft2, color, (VertexConsumer)buf, stack);
        this.drawSide(topLeft2, topRight2, topLeft, topRight, color, (VertexConsumer)buf, stack);
        this.drawSide(bottomLeft2, bottomRight2, bottomLeft, bottomRight, color, (VertexConsumer)buf, stack);
    }

    private void drawSide(Vec3 tr, Vec3 tl, Vec3 br, Vec3 bl, ColorData color, VertexConsumer buf, PoseStack pose) {
        Matrix4f mat = pose.m_85850_().m_252922_();
        buf.m_252986_(mat, (float)tr.f_82479_, (float)tr.f_82480_, (float)tr.f_82481_).m_85950_(color.getRf(), color.getGf(), color.getBf(), color.getAf()).m_5752_();
        buf.m_252986_(mat, (float)br.f_82479_, (float)br.f_82480_, (float)br.f_82481_).m_85950_(color.getRf(), color.getGf(), color.getBf(), color.getAf()).m_5752_();
        buf.m_252986_(mat, (float)bl.f_82479_, (float)bl.f_82480_, (float)bl.f_82481_).m_85950_(color.getRf(), color.getGf(), color.getBf(), color.getAf()).m_5752_();
        buf.m_252986_(mat, (float)tl.f_82479_, (float)tl.f_82480_, (float)tl.f_82481_).m_85950_(color.getRf(), color.getGf(), color.getBf(), color.getAf()).m_5752_();
    }

    public void createVBO(AnalyserMode mode, NetworkData data) {
        if (VBO != null) {
            VBO.close();
        }
        BufferBuilder buf = new BufferBuilder(this.CUBE_RENDER.m_110507_() * 8);
        buf.m_166779_(this.CUBE_RENDER.m_173186_(), this.CUBE_RENDER.m_110508_());
        PoseStack stack = new PoseStack();
        if (renderNodeModes.contains((Object)mode)) {
            this.renderNodes(data, stack, buf);
        }
        if (renderLinkModes.contains((Object)mode)) {
            this.renderLinks(data, stack, buf, mode == AnalyserMode.P2P);
        }
        BufferBuilder.RenderedBuffer rendered = buf.m_231175_();
        VBO = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        VBO.m_85921_();
        VBO.m_231221_(rendered);
        VertexBuffer.m_85931_();
    }

    public void tick(PoseStack stack, MultiBufferSource.BufferSource multiBuf, Matrix4f pro, Camera camera) {
        if (NetworkDataHandler.pullData() == null || GameRenderer.m_172811_() == null) {
            return;
        }
        if (camera.m_90593_()) {
            Vec3 offset = camera.m_90583_().m_82548_();
            AnalyserMode mode = NetworkDataHandler.getMode();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (NetworkDataHandler.update()) {
                this.createVBO(mode, NetworkDataHandler.pullData());
            }
            if (VBO != null) {
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.disableCull();
                stack.m_85836_();
                stack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                VBO.m_85921_();
                VBO.m_253207_(stack.m_85850_().m_252922_(), pro, GameRenderer.m_172811_());
                VertexBuffer.m_85931_();
                stack.m_85849_();
                RenderSystem.enableCull();
            }
            RenderSystem.disableBlend();
            if (mode == AnalyserMode.FULL && !Util.isInfChannel()) {
                for (NetworkData.ALink link : NetworkDataHandler.pullData().links) {
                    if (link.channel() <= 0) continue;
                    this.drawInWorldText(String.valueOf(link.channel()), WHITE, ClientUtil.getCenter(link.a().pos(), link.b().pos()), offset, camera, stack, (MultiBufferSource)multiBuf);
                }
            }
            multiBuf.m_109911_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    public NetworkRender() {
        super("", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 0, false, false, () -> {}, () -> {});
    }

    static {
        WHITE = new ColorData(1.0f, 1.0f, 1.0f);
        VBO = null;
    }
}

