/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.config;

import it.crystalnest.cobweb.api.config.CommonConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModConfig
extends CommonConfig {
    public static final ModConfig CONFIG = (ModConfig)ModConfig.register((String)"soul_fire_d", ModConfig::new);
    private static final String SOUL_FIRE_ASPECT = "Soul Fire Aspect";
    private static final String SOUL_FLAME = "Soul Flame";
    private ForgeConfigSpec.BooleanValue enableSoulFireAspect;
    private ForgeConfigSpec.BooleanValue enableSoulFireAspectDiscovery;
    private ForgeConfigSpec.BooleanValue enableSoulFireAspectTrades;
    private ForgeConfigSpec.BooleanValue enableSoulFireAspectTreasure;
    private ForgeConfigSpec.BooleanValue enableSoulFlame;
    private ForgeConfigSpec.BooleanValue enableSoulFlameDiscovery;
    private ForgeConfigSpec.BooleanValue enableSoulFlameTrades;
    private ForgeConfigSpec.BooleanValue enableSoulFlameTreasure;

    private ModConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
    }

    public static Boolean getEnableSoulFireAspect() {
        return (Boolean)ModConfig.CONFIG.enableSoulFireAspect.get();
    }

    public static Boolean getEnableSoulFireAspectDiscovery() {
        return (Boolean)ModConfig.CONFIG.enableSoulFireAspectDiscovery.get();
    }

    public static Boolean getEnableSoulFireAspectTrades() {
        return (Boolean)ModConfig.CONFIG.enableSoulFireAspectTrades.get();
    }

    public static Boolean getEnableSoulFireAspectTreasure() {
        return (Boolean)ModConfig.CONFIG.enableSoulFireAspectTreasure.get();
    }

    public static Boolean getEnableSoulFlame() {
        return (Boolean)ModConfig.CONFIG.enableSoulFlame.get();
    }

    public static Boolean getEnableSoulFlameDiscovery() {
        return (Boolean)ModConfig.CONFIG.enableSoulFlameDiscovery.get();
    }

    public static Boolean getEnableSoulFlameTrades() {
        return (Boolean)ModConfig.CONFIG.enableSoulFlameTrades.get();
    }

    public static Boolean getEnableSoulFlameTreasure() {
        return (Boolean)ModConfig.CONFIG.enableSoulFlameTreasure.get();
    }

    private static ForgeConfigSpec.BooleanValue defineEnableEnchantment(ForgeConfigSpec.Builder builder, String enchantment) {
        return builder.comment(new String[]{" Whether to enable " + enchantment + " enchantment.", " Takes precedence over all other " + enchantment + " configs."}).define("enable " + enchantment.toLowerCase(), true);
    }

    private static ForgeConfigSpec.BooleanValue defineEnableTreasure(ForgeConfigSpec.Builder builder, String enchantment) {
        return builder.comment(new String[]{" Whether " + enchantment + " cannot appear in the enchanting table.", " If enabled along with [enable " + enchantment.toLowerCase() + " discovery], the enchantment won't appear in the enchanting table, but can still be found in loots."}).define("enable " + enchantment.toLowerCase() + " treasure", false);
    }

    private static ForgeConfigSpec.BooleanValue defineEnableDiscovery(ForgeConfigSpec.Builder builder, String enchantment) {
        return builder.comment(new String[]{" Whether " + enchantment + " can appear in the enchanting table and loots.", " [enable " + enchantment + " treasure] takes precedence."}).define("enable " + enchantment + " discovery", true);
    }

    private static ForgeConfigSpec.BooleanValue defineEnableTrades(ForgeConfigSpec.Builder builder, String enchantment) {
        return builder.comment(" Whether " + enchantment + " can be found in villager trades.").define("enable " + enchantment + " trades", true);
    }

    protected void define(ForgeConfigSpec.Builder builder) {
        this.enableSoulFireAspect = ModConfig.defineEnableEnchantment(builder, SOUL_FIRE_ASPECT);
        this.enableSoulFireAspectTreasure = ModConfig.defineEnableTreasure(builder, SOUL_FIRE_ASPECT);
        this.enableSoulFireAspectDiscovery = ModConfig.defineEnableDiscovery(builder, SOUL_FIRE_ASPECT);
        this.enableSoulFireAspectTrades = ModConfig.defineEnableTrades(builder, SOUL_FIRE_ASPECT);
        this.enableSoulFlame = ModConfig.defineEnableEnchantment(builder, SOUL_FLAME);
        this.enableSoulFlameTreasure = ModConfig.defineEnableTreasure(builder, SOUL_FLAME);
        this.enableSoulFlameDiscovery = ModConfig.defineEnableDiscovery(builder, SOUL_FLAME);
        this.enableSoulFlameTrades = ModConfig.defineEnableTrades(builder, SOUL_FLAME);
    }
}

