/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.enchantment;

import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTypeChanger;
import it.crystalnest.soul_fire_d.api.type.FireTypedEnchantment;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.FireAspectEnchantment;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public final class FireTypedFireAspectEnchantment
extends FireAspectEnchantment
implements FireTypedEnchantment {
    private final ResourceLocation fireType;
    private final BooleanSupplier enabled;
    private final Predicate<Enchantment> compatibility;
    private final TriFunction<Entity, Entity, Integer, Integer> duration;
    private final BooleanSupplier isTreasure;
    private final BooleanSupplier isCurse;
    private final BooleanSupplier isTradeable;
    private final BooleanSupplier isDiscoverable;

    FireTypedFireAspectEnchantment(ResourceLocation fireType, Enchantment.Rarity rarity, BooleanSupplier isTreasure, BooleanSupplier isCurse, BooleanSupplier isTradeable, BooleanSupplier isDiscoverable, BooleanSupplier enabled, Predicate<Enchantment> compatibility, TriFunction<Entity, Entity, Integer, Integer> duration) {
        super(rarity, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
        this.fireType = FireManager.sanitize(fireType);
        this.isTreasure = isTreasure;
        this.isCurse = isCurse;
        this.isTradeable = isTradeable;
        this.isDiscoverable = isDiscoverable;
        this.enabled = enabled;
        this.compatibility = compatibility;
        this.duration = duration;
    }

    private static boolean wasLastHitByProjectile(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            DamageSource lastDamageSource = livingEntity.m_21225_();
            return lastDamageSource != null && lastDamageSource.m_269533_(DamageTypeTags.f_268524_);
        }
        return false;
    }

    public boolean m_5975_(@NotNull Enchantment enchantment) {
        return this.enabled.getAsBoolean() && super.m_5975_(enchantment) && !(enchantment instanceof FireAspectEnchantment) && this.compatibility.test(enchantment);
    }

    public boolean m_6081_(@NotNull ItemStack itemStack) {
        return this.enabled.getAsBoolean() && super.m_6081_(itemStack);
    }

    public void m_7677_(@NotNull LivingEntity attacker, @NotNull Entity target, int level) {
        if (!FireTypedFireAspectEnchantment.wasLastHitByProjectile(target)) {
            if (!attacker.m_9236_().f_46443_) {
                target.m_20254_(this.duration((Entity)attacker, target, level * 4));
            }
            ((FireTypeChanger)target).setFireType(FireManager.ensure(this.fireType));
        }
    }

    public boolean m_6591_() {
        return this.isTreasure.getAsBoolean();
    }

    public boolean m_6589_() {
        return this.isCurse.getAsBoolean();
    }

    public boolean m_6594_() {
        return this.isTradeable.getAsBoolean() && this.enabled.getAsBoolean();
    }

    public boolean m_6592_() {
        return this.isDiscoverable.getAsBoolean() && this.enabled.getAsBoolean();
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }

    @Override
    public int duration(Entity attacker, Entity target, Integer duration) {
        return (Integer)this.duration.apply((Object)attacker, (Object)target, (Object)duration);
    }
}

