/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.enchantment;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import java.util.List;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public final class FireEnchantmentHelper {
    private FireEnchantmentHelper() {
    }

    public static int getBaseFireAspect(LivingEntity entity) {
        return FireEnchantmentHelper.getFireEquipmentLevel(Enchantments.f_44981_, entity);
    }

    public static int getBaseFireAspect(ItemStack stack) {
        return FireEnchantmentHelper.getFireLevel(Enchantments.f_44981_, stack);
    }

    public static int getAnyFireAspect(LivingEntity entity) {
        return FireEnchantmentHelper.getWhichFireAspect(entity).getLevel();
    }

    public static int getAnyFireAspect(ItemStack stack) {
        return FireEnchantmentHelper.getWhichFireAspect(stack).getLevel();
    }

    public static FireEnchantment getWhichFireAspect(LivingEntity entity) {
        return FireEnchantmentHelper.getAnyFireEnchantment(entity, FireManager.getComponentList(Fire.Component.FIRE_ASPECT_ENCHANTMENT), FireEnchantmentHelper::getBaseFireAspect, EnchantmentHelper::m_44836_);
    }

    public static FireEnchantment getWhichFireAspect(ItemStack stack) {
        return FireEnchantmentHelper.getAnyFireEnchantment(stack, FireManager.getComponentList(Fire.Component.FIRE_ASPECT_ENCHANTMENT), FireEnchantmentHelper::getBaseFireAspect, EnchantmentHelper::m_44843_);
    }

    public static int getBaseFlame(LivingEntity entity) {
        return FireEnchantmentHelper.getFireEquipmentLevel(Enchantments.f_44990_, entity);
    }

    public static int getBaseFlame(ItemStack stack) {
        return FireEnchantmentHelper.getFireLevel(Enchantments.f_44990_, stack);
    }

    public static int getAnyFlame(LivingEntity entity) {
        return FireEnchantmentHelper.getWhichFlame(entity).getLevel();
    }

    public static int getAnyFlame(ItemStack stack) {
        return FireEnchantmentHelper.getWhichFlame(stack).getLevel();
    }

    public static FireEnchantment getWhichFlame(LivingEntity entity) {
        return FireEnchantmentHelper.getAnyFireEnchantment(entity, FireManager.getComponentList(Fire.Component.FLAME_ENCHANTMENT), FireEnchantmentHelper::getBaseFlame, EnchantmentHelper::m_44836_);
    }

    public static FireEnchantment getWhichFlame(ItemStack stack) {
        return FireEnchantmentHelper.getAnyFireEnchantment(stack, FireManager.getComponentList(Fire.Component.FLAME_ENCHANTMENT), FireEnchantmentHelper::getBaseFlame, EnchantmentHelper::m_44843_);
    }

    private static <T> FireEnchantment getAnyFireEnchantment(T enchanted, List<? extends Enchantment> enchantments, ToIntFunction<T> getBaseFireEnchantment, ToIntBiFunction<Enchantment, T> getLevel) {
        int fireEnchantmentLevel = getBaseFireEnchantment.applyAsInt(enchanted);
        ResourceLocation fireType = FireManager.DEFAULT_FIRE_TYPE;
        if (fireEnchantmentLevel <= 0) {
            for (Enchantment enchantment : enchantments) {
                int enchantmentLevel = getLevel.applyAsInt(enchantment, (Enchantment)enchanted);
                if (enchantmentLevel <= 0) continue;
                fireEnchantmentLevel = enchantmentLevel;
                fireType = ((FireTyped)enchantment).getFireType();
                break;
            }
        }
        return new FireEnchantment(fireEnchantmentLevel, (ResourceLocation)(fireEnchantmentLevel > 0 ? fireType : null));
    }

    private static int getFireEquipmentLevel(Enchantment enchantment, LivingEntity entity) {
        int i = 0;
        for (ItemStack stack : enchantment.m_44684_(entity).values()) {
            int j = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    private static int getFireLevel(Enchantment enchantment, ItemStack stack) {
        if (!stack.m_41619_()) {
            ResourceLocation idToFind = EnchantmentHelper.m_182432_((Enchantment)enchantment);
            ListTag tags = stack.m_41785_();
            for (int i = 0; i < tags.size(); ++i) {
                CompoundTag tag = tags.m_128728_(i);
                ResourceLocation enchantmentId = EnchantmentHelper.m_182446_((CompoundTag)tag);
                if (enchantmentId == null || !enchantmentId.equals((Object)idToFind)) continue;
                return EnchantmentHelper.m_182438_((CompoundTag)tag);
            }
        }
        return 0;
    }

    public static class FireEnchantment {
        private final int level;
        private final ResourceLocation fireType;
        private final boolean applied;

        FireEnchantment(int level, ResourceLocation fireType) {
            this.level = level;
            this.fireType = fireType;
            this.applied = level > 0 && (FireManager.DEFAULT_FIRE_TYPE.equals((Object)fireType) || FireManager.isRegisteredType(fireType));
        }

        public int getLevel() {
            return this.level;
        }

        public ResourceLocation getFireType() {
            return this.fireType;
        }

        public boolean isApplied() {
            return this.applied;
        }
    }
}

