/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.enchantment;

import it.crystalnest.cobweb.api.registry.CobwebRegistry;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.function.TriFunction;

public abstract class FireEnchantmentBuilder<T extends Enchantment> {
    public static final Enchantment.Rarity DEFAULT_RARITY = Enchantment.Rarity.VERY_RARE;
    public static final boolean DEFAULT_IS_TREASURE = false;
    public static final boolean DEFAULT_IS_CURSE = false;
    public static final boolean DEFAULT_IS_TRADEABLE = true;
    public static final boolean DEFAULT_IS_DISCOVERABLE = true;
    protected final ResourceLocation fireType;
    private final String kind;
    protected BooleanSupplier enabled = () -> true;
    protected Predicate<Enchantment> compatibility = enchantment -> true;
    protected TriFunction<Entity, Entity, Integer, Integer> duration = (attacker, target, seconds) -> seconds;
    protected Enchantment.Rarity rarity = DEFAULT_RARITY;
    protected BooleanSupplier isTreasure = () -> false;
    protected BooleanSupplier isCurse = () -> false;
    protected BooleanSupplier isTradeable = () -> true;
    protected BooleanSupplier isDiscoverable = () -> true;

    protected FireEnchantmentBuilder(ResourceLocation fireType, String kind) {
        this.fireType = fireType;
        this.kind = kind;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setRarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsTreasure(BooleanSupplier isTreasure) {
        this.isTreasure = isTreasure;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsTreasure(boolean isTreasure) {
        return this.setIsTreasure(() -> isTreasure);
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsCurse(BooleanSupplier isCurse) {
        this.isCurse = isCurse;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsCurse(boolean isCurse) {
        return this.setIsCurse(() -> isCurse);
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsTradeable(BooleanSupplier isTradeable) {
        this.isTradeable = isTradeable;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsTradeable(boolean isTradeable) {
        return this.setIsTradeable(() -> isTradeable);
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsDiscoverable(BooleanSupplier isDiscoverable) {
        this.isDiscoverable = isDiscoverable;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setIsDiscoverable(boolean isDiscoverable) {
        return this.setIsDiscoverable(() -> isDiscoverable);
    }

    public final <B extends FireEnchantmentBuilder<T>> B setCompatibility(Predicate<Enchantment> compatibility) {
        this.compatibility = compatibility;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setDuration(TriFunction<Entity, Entity, Integer, Integer> duration) {
        this.duration = duration;
        return (B)this;
    }

    public final <B extends FireEnchantmentBuilder<T>> B setDuration(int duration) {
        this.duration = (attacker, target, base) -> duration;
        return (B)this;
    }

    public ResourceLocation register() {
        ResourceLocation key = new ResourceLocation(this.fireType.m_135827_(), this.fireType.m_135815_() + "_" + this.kind);
        CobwebRegistry.of((ResourceKey)Registries.f_256762_, (String)key.m_135827_()).register(key.m_135815_(), this::build);
        return key;
    }

    protected abstract T build();
}

