/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.block;

import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public class CustomWallTorchBlock
extends WallTorchBlock
implements FireTyped {
    private final ResourceLocation fireType;
    private final Supplier<? extends ParticleOptions> type;

    public CustomWallTorchBlock(ResourceLocation fireType, Supplier<? extends ParticleOptions> type) {
        this(fireType, type, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56736_).m_60916_(FireManager.getRequiredComponent(fireType, Fire.Component.TORCH_BLOCK)).m_278166_(PushReaction.DESTROY));
    }

    public CustomWallTorchBlock(ResourceLocation fireType, Supplier<? extends ParticleOptions> type, BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> FireManager.getProperty(fireType, Fire::getLight)), null);
        this.fireType = fireType;
        this.type = type;
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.f_57488_ == null) {
            this.f_57488_ = this.type.get();
        }
        super.m_214162_(state, level, pos, random);
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }
}

