/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.init;

import com.jkvin114.displaydelight.block.DrinkBlock;
import com.jkvin114.displaydelight.block.EmptyPlateBlock;
import com.jkvin114.displaydelight.block.EmptySmallPlateBlock;
import com.jkvin114.displaydelight.block.FoodBlock;
import com.jkvin114.displaydelight.block.WideFoodBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DisplayBlocks {
    public static List<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"displaydelight");
    public static final RegistryObject<Block> PLATE = REGISTRY.register("food_plate", () -> new EmptyPlateBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> SMALL_PLATE = REGISTRY.register("small_food_plate", () -> new EmptySmallPlateBlock(BlockBehaviour.Properties.m_284310_().m_60966_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Block> GLOW_BERRY_CUSTARD = DisplayBlocks.createDrinkFoodBlock("glow_berry_custard");
    public static final RegistryObject<Block> FRUIT_SALAD = DisplayBlocks.createFoodBlock("fruit_salad");
    public static final RegistryObject<Block> COOKED_RICE = DisplayBlocks.createFoodBlock("cooked_rice");
    public static final RegistryObject<Block> MIXED_SALAD = DisplayBlocks.createFoodBlock("mixed_salad");
    public static final RegistryObject<Block> BEEF_STEW = DisplayBlocks.createFoodBlock("beef_stew");
    public static final RegistryObject<Block> CHICKEN_SOUP = DisplayBlocks.createFoodBlock("chicken_soup");
    public static final RegistryObject<Block> VEGETABLE_SOUP = DisplayBlocks.createFoodBlock("vegetable_soup");
    public static final RegistryObject<Block> FISH_STEW = DisplayBlocks.createFoodBlock("fish_stew");
    public static final RegistryObject<Block> FRIED_RICE = DisplayBlocks.createFoodBlock("fried_rice");
    public static final RegistryObject<Block> PUMPKIN_SOUP = DisplayBlocks.createFoodBlock("pumpkin_soup");
    public static final RegistryObject<Block> BAKED_COD_STEW = DisplayBlocks.createFoodBlock("baked_cod_stew");
    public static final RegistryObject<Block> NOODLE_SOUP = DisplayBlocks.createFoodBlock("noodle_soup");
    public static final RegistryObject<Block> BONE_BROTH = DisplayBlocks.createFoodBlock("bone_broth");
    public static final RegistryObject<Block> BACON_AND_EGGS = DisplayBlocks.createWideFoodBlock("bacon_and_eggs");
    public static final RegistryObject<Block> PASTA_WITH_MEATBALLS = DisplayBlocks.createWideFoodBlock("pasta_with_meatballs");
    public static final RegistryObject<Block> PASTA_WITH_MUTTON_CHOP = DisplayBlocks.createWideFoodBlock("pasta_with_mutton_chop");
    public static final RegistryObject<Block> ROASTED_MUTTON_CHOPS = DisplayBlocks.createWideFoodBlock("roasted_mutton_chops");
    public static final RegistryObject<Block> STEAK_AND_POTATOES = DisplayBlocks.createWideFoodBlock("steak_and_potatoes");
    public static final RegistryObject<Block> VEGETABLE_NOODLES = DisplayBlocks.createWideFoodBlock("vegetable_noodles");
    public static final RegistryObject<Block> RATATOUILLE = DisplayBlocks.createWideFoodBlock("ratatouille");
    public static final RegistryObject<Block> SQUID_INK_PASTA = DisplayBlocks.createWideFoodBlock("squid_ink_pasta");
    public static final RegistryObject<Block> GRILLED_SALMON = DisplayBlocks.createWideFoodBlock("grilled_salmon");
    public static final RegistryObject<Block> MUSHROOM_RICE = DisplayBlocks.createWideFoodBlock("mushroom_rice");
    public static final RegistryObject<Block> ROAST_CHICKEN = DisplayBlocks.createFoodBlock("roast_chicken");
    public static final RegistryObject<Block> STUFFED_PUMPKIN = DisplayBlocks.createFoodBlock("stuffed_pumpkin");
    public static final RegistryObject<Block> HONEY_GLAZED_HAM = DisplayBlocks.createFoodBlock("honey_glazed_ham");
    public static final RegistryObject<Block> SHEPHEREDS_PIE = DisplayBlocks.createFoodBlock("shepherds_pie");
    public static final RegistryObject<Block> APPLE_CIDER = DisplayBlocks.createDrinkFoodBlock("apple_cider");
    public static final RegistryObject<Block> MELON_JUICE = DisplayBlocks.createDrinkFoodBlock("melon_juice");
    public static final RegistryObject<Block> HOT_COCOA = DisplayBlocks.createDrinkFoodBlock("hot_cocoa");
    public static final RegistryObject<Block> MUSHROOM_STEW = DisplayBlocks.createFoodBlock("mushroom_stew");
    public static final RegistryObject<Block> RABBIT_STEW = DisplayBlocks.createFoodBlock("rabbit_stew");
    public static final RegistryObject<Block> BEETROOT_STEW = DisplayBlocks.createFoodBlock("beetroot_soup");
    public static final RegistryObject<Block> CD_NACHOS_BOWL = DisplayBlocks.createFoodBlock("cd_nachos_bowl");
    public static final RegistryObject<Block> CD_CREAMY_COR_DRINK = DisplayBlocks.createDrinkFoodBlock("cd_creamy_corn_drink");
    public static final RegistryObject<Block> CD_CORNBREAD_STUFFING = DisplayBlocks.createFoodBlock("cd_cornbread_stuffing");
    public static final RegistryObject<Block> CD_CORN_SOUP = DisplayBlocks.createFoodBlock("cd_corn_soup");
    public static final RegistryObject<Block> CD_CREAMED_CORN = DisplayBlocks.createFoodBlock("cd_creamed_corn");
    public static final RegistryObject<Block> DF_MATCHA_ICE_CREAM = DisplayBlocks.createFoodBlock("df_matcha_ice_cream");
    public static final RegistryObject<Block> DF_MATCHA_MILKSHAKE = DisplayBlocks.createDrinkFoodBlock("df_matcha_milkshake");
    public static final RegistryObject<Block> DF_SALMONBERRY_ICE_CREAM = DisplayBlocks.createFoodBlock("df_salmonberry_ice_cream");
    public static final RegistryObject<Block> DF_SALMONBERRY_MILKSHAKE = DisplayBlocks.createDrinkFoodBlock("df_salmonberry_milkshake");
    public static final RegistryObject<Block> DF_MATCHA_LATTE = DisplayBlocks.createDrinkFoodBlock("df_matcha_latte");
    public static final RegistryObject<Block> DF_ENDER_NECTAR = DisplayBlocks.createDrinkFoodBlock("df_ender_nectar");
    public static final RegistryObject<Block> DF_BERRY_MATCHA_LATTE = DisplayBlocks.createDrinkFoodBlock("df_berry_matcha_latte");
    public static final RegistryObject<Block> DF_CACTUS_CHILI = DisplayBlocks.createFoodBlock("df_cactus_chili");
    public static final RegistryObject<Block> DF_FIELD_SALAD = DisplayBlocks.createFoodBlock("df_field_salad");
    public static final RegistryObject<Block> DF_STUFFED_CANTALOUPE = DisplayBlocks.createFoodBlock("df_stuffed_cantaloupe");
    public static final RegistryObject<Block> DF_SINIGANG = DisplayBlocks.createFoodBlock("df_sinigang");
    public static final RegistryObject<Block> DF_CACTUS_SOUP = DisplayBlocks.createFoodBlock("df_cactus_soup");
    public static final RegistryObject<Block> PD_PINEAPPLE_FRIED_RICE = DisplayBlocks.createFoodBlock("pd_pineapple_fried_rice");
    public static final RegistryObject<Block> PD_PINEAPPLE_ICE_CREAM = DisplayBlocks.createDrinkFoodBlock("pd_pineapple_ice_cream");
    public static final RegistryObject<Block> PD_PINEAPPLE_MILK_SHAKE = DisplayBlocks.createDrinkFoodBlock("pd_pineapple_milk_shake");
    public static final RegistryObject<Block> PD_PINEAPPLE_JUICE = DisplayBlocks.createDrinkFoodBlock("pd_pineapple_juice");
    public static final RegistryObject<Block> OD_BOWL_OF_GUARDIAN_SOUP = DisplayBlocks.createFoodBlock("od_bowl_of_guardian_soup");
    public static final RegistryObject<Block> OD_BRAISED_SEA_PICKLE = DisplayBlocks.createFoodBlock("od_braised_sea_pickle");
    public static final RegistryObject<Block> OD_SEAGRASS_SALAD = DisplayBlocks.createFoodBlock("od_seagrass_salad");
    public static final RegistryObject<Block> OD_SQUID_RINGS = DisplayBlocks.createFoodBlock("od_squid_rings");
    public static final RegistryObject<Block> AD_MAGGOT_SALAD = DisplayBlocks.createFoodBlock("ad_maggot_salad");
    public static final RegistryObject<Block> AD_KANGAROO_STEW = DisplayBlocks.createFoodBlock("ad_kangaroo_stew");
    public static final RegistryObject<Block> AD_ACACIA_BLOSSOM_SOUP = DisplayBlocks.createFoodBlock("ad_acacia_blossom_soup");
    public static final RegistryObject<Block> AD_LOBSTER_PASTA = DisplayBlocks.createWideFoodBlock("ad_lobster_pasta");
    public static final RegistryObject<Block> AD_KANGAROO_PASTA = DisplayBlocks.createWideFoodBlock("ad_kangaroo_pasta");
    public static final RegistryObject<Block> CTD_HEARTY_SALAD = DisplayBlocks.createFoodBlock("ctd_hearty_salad");
    public static final RegistryObject<Block> CTD_CREAMED_CORN = DisplayBlocks.createFoodBlock("ctd_creamed_corn");
    public static final RegistryObject<Block> CTD_SPICY_CURRY = DisplayBlocks.createFoodBlock("ctd_spicy_curry");
    public static final RegistryObject<Block> CTD_FRIED_EGGPLANT_PASTA = DisplayBlocks.createWideFoodBlock("ctd_fried_eggplant_pasta");
    public static final RegistryObject<Block> LM_PUFFERFISH_BROTH = DisplayBlocks.createFoodBlock("lm_pufferfish_broth");
    public static final RegistryObject<Block> LM_POTATO_SOUP = DisplayBlocks.createFoodBlock("lm_potato_soup");
    public static final RegistryObject<Block> LM_RED_SOUP = DisplayBlocks.createFoodBlock("lm_red_soup");
    public static final RegistryObject<Block> LM_TOMATO_EGG_SOUP = DisplayBlocks.createFoodBlock("lm_tomato_egg_soup");
    public static final RegistryObject<Block> LM_COD_DELUXE = DisplayBlocks.createWideFoodBlock("lm_cod_deluxe");
    public static final RegistryObject<Block> LM_HEARTY_LUNCH = DisplayBlocks.createWideFoodBlock("lm_hearty_lunch");
    public static final RegistryObject<Block> LM_CHICKEN_CURRY = DisplayBlocks.createWideFoodBlock("lm_chicken_curry");
    public static final RegistryObject<Block> LM_PASTA_WITH_MUSHROOM_SAUCE = DisplayBlocks.createWideFoodBlock("lm_pasta_with_mushroom_sauce");
    public static final RegistryObject<Block> LM_OMURICE = DisplayBlocks.createFoodBlock("lm_omurice");
    public static final RegistryObject<Block> LM_MUSHROOM_POT_PIE = DisplayBlocks.createFoodBlock("lm_mushroom_pot_pie");
    public static final RegistryObject<Block> LM_ROASTED_MUTTOH_RACK = DisplayBlocks.createFoodBlock("lm_roasted_mutton_rack");
    public static final RegistryObject<Block> LM_SWEET_BERRY_CUSTARD = DisplayBlocks.createDrinkFoodBlock("lm_sweet_berry_custard");
    public static final RegistryObject<Block> LM_RICE_PUDDING = DisplayBlocks.createFoodBlock("lm_rice_pudding");
    public static final RegistryObject<Block> FD_FESTIVE_CHICKEN = DisplayBlocks.createFoodBlock("fd_festive_chicken");
    public static final RegistryObject<Block> FD_CHRISTMAS_TEA = DisplayBlocks.createDrinkFoodBlock("fd_christmas_tea");
    public static final RegistryObject<Block> FD_SALMON_VERRINES = DisplayBlocks.createDrinkFoodBlock("fd_salmon_verrines");

    public static List<Block> getAll() {
        return blocks.stream().map(RegistryObject::get).toList();
    }

    private static BlockBehaviour.Properties baseProps() {
        return BlockBehaviour.Properties.m_284310_().m_60955_().m_60966_().m_278166_(PushReaction.DESTROY).m_284180_(MapColor.f_283808_);
    }

    public static RegistryObject<Block> createDrinkFoodBlock(String name) {
        RegistryObject block = REGISTRY.register(name, () -> new DrinkBlock(DisplayBlocks.baseProps().m_60918_(SoundType.f_56744_)));
        blocks.add((RegistryObject<Block>)block);
        return block;
    }

    public static RegistryObject<Block> createWideFoodBlock(String name) {
        RegistryObject block = REGISTRY.register(name, () -> new WideFoodBlock(DisplayBlocks.baseProps().m_60918_(SoundType.f_56736_)));
        blocks.add((RegistryObject<Block>)block);
        return block;
    }

    public static RegistryObject<Block> createFoodBlock(String name) {
        RegistryObject block = REGISTRY.register(name, () -> new FoodBlock(DisplayBlocks.baseProps().m_60918_(SoundType.f_56736_)));
        blocks.add((RegistryObject<Block>)block);
        return block;
    }
}

