/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.recipes;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class CustomFanRecipe
extends ProcessingRecipe<CustomFanWrapper> {
    public CustomFanRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CMRRecipeTypes.CUSTOM_FAN, params);
    }

    public boolean matches(CustomFanWrapper inv, Level worldIn) {
        return inv.m_7983_() ? false : ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    public boolean matches(CustomFanWrapper inv, Level worldIn, Block block) {
        return inv.m_7983_() ? false : ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0)) && this.getProcessingBlock().contains(block);
    }

    public List<Block> getProcessingBlock() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (this.ingredients.size() > 1) {
            for (ItemStack item : ((Ingredient)this.ingredients.get(1)).m_43908_()) {
                Item item2 = item.m_41720_();
                if (!(item2 instanceof BlockItem)) continue;
                BlockItem bi = (BlockItem)item2;
                blocks.add(bi.m_40614_());
            }
        }
        for (FluidIngredient fluid : this.fluidIngredients) {
            blocks.addAll(fluid.getMatchingFluidStacks().stream().map(f -> f.getFluid().m_76145_().m_76188_().m_60734_()).toList());
        }
        return blocks;
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected int getMaxOutputCount() {
        return 12;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    public static class CustomFanWrapper
    extends RecipeWrapper {
        public CustomFanWrapper(ItemStackHandler handler) {
            super((IItemHandlerModifiable)handler);
        }
    }
}

