/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.init;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.infrastructure.config.AllConfigs;
import fr.iglee42.cmr.CreateMoreRecipes;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import fr.iglee42.cmr.recipes.CustomFanRecipe;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CMRFanProcessingTypes
extends AllFanProcessingTypes {
    public static final CustomizableFanType CUSTOM = CMRFanProcessingTypes.register("custom", new CustomizableFanType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String id, T type) {
        Registry.m_122965_((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)CreateMoreRecipes.asResource(id), type);
        return type;
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = CMRFanProcessingTypes.ofLegacyName(str);
        return type != null ? type : FanProcessingType.parse((String)str);
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"CUSTOM", (Object)CUSTOM);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class CustomizableFanType
    implements FanProcessingType {
        private FanProcessingType.AirFlowParticleAccess access;

        public boolean isValidAt(Level level, BlockPos blockPos) {
            Block block = level.m_8055_(blockPos).m_60734_();
            return level.m_7465_().m_44013_(CMRRecipeTypes.CUSTOM_FAN.getType()).stream().anyMatch(r -> {
                ProcessingRecipe r1 = (ProcessingRecipe)r;
                CustomFanRecipe r2 = (CustomFanRecipe)r1;
                return r2.getProcessingBlock().contains(block);
            });
        }

        public int getPriority() {
            return 2000;
        }

        public boolean canProcess(ItemStack itemStack, Level level) {
            return false;
        }

        @Nullable
        public List<ItemStack> process(ItemStack itemStack, Level level) {
            return null;
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess airFlowParticleAccess, RandomSource randomSource) {
            this.access = airFlowParticleAccess;
        }

        public void affectEntity(Entity entity, Level level) {
        }

        public FanProcessingType.AirFlowParticleAccess getAccess() {
            return this.access;
        }

        private boolean canProcess(ItemStack itemStack, Level level, Direction fanDir, BlockPos fanPos, double entityDistance) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, itemStack);
            if (this.isValidAt(level, CreateMoreRecipes.getPosOfCatalyst(fanPos, level, fanDir, (int)entityDistance))) {
                Block block = level.m_8055_(CreateMoreRecipes.getPosOfCatalyst(fanPos, level, fanDir, (int)entityDistance)).m_60734_();
                return level.m_7465_().m_44013_(CMRRecipeTypes.CUSTOM_FAN.getType()).stream().anyMatch(r -> {
                    ProcessingRecipe r1 = (ProcessingRecipe)r;
                    CustomFanRecipe r2 = (CustomFanRecipe)r1;
                    return r2.matches(new CustomFanRecipe.CustomFanWrapper(handler), level, block);
                });
            }
            return false;
        }

        public boolean canCustomProcess(ItemEntity entity, FanProcessingType type, Level level, Direction dir, BlockPos fanPos, double entityDistance) {
            CompoundTag compound;
            if (entity.getPersistentData().m_128441_("CreateData") && (compound = entity.getPersistentData().m_128469_("CreateData")).m_128441_("Processing")) {
                CompoundTag processing = compound.m_128469_("Processing");
                if (AllFanProcessingTypes.parseLegacy((String)processing.m_128461_("Type")) != type) {
                    return this.canProcess(entity.m_32055_(), entity.m_9236_(), dir, fanPos, entityDistance);
                }
                if (processing.m_128451_("Time") >= 0) {
                    return true;
                }
                if (processing.m_128451_("Time") == -1) {
                    return false;
                }
            }
            return this.canProcess(entity.m_32055_(), entity.m_9236_(), dir, fanPos, entityDistance);
        }

        @Nullable
        public List<ItemStack> process(ItemStack itemStack, Level level, Direction dir, BlockPos fanPos, double entityDistance) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, itemStack);
            if (this.isValidAt(level, CreateMoreRecipes.getPosOfCatalyst(fanPos, level, dir, (int)entityDistance))) {
                Block block = level.m_8055_(CreateMoreRecipes.getPosOfCatalyst(fanPos, level, dir, (int)entityDistance)).m_60734_();
                Optional<Recipe> recipe = level.m_7465_().m_44013_(CMRRecipeTypes.CUSTOM_FAN.getType()).stream().filter(r -> {
                    ProcessingRecipe r1 = (ProcessingRecipe)r;
                    CustomFanRecipe r2 = (CustomFanRecipe)r1;
                    return r2.matches(new CustomFanRecipe.CustomFanWrapper(handler), level, block);
                }).findFirst();
                return recipe.isPresent() ? RecipeApplier.applyRecipeOn((Level)level, (ItemStack)itemStack, (Recipe)recipe.get()) : null;
            }
            return null;
        }

        public boolean applyProcessingEntity(ItemEntity entity, FanProcessingType type, Direction dir, BlockPos fanPos, double entityDistance) {
            if (CustomizableFanType.decrementProcessingTime(entity, type) != 0) {
                return false;
            }
            List<ItemStack> stacks = this.process(entity.m_32055_(), entity.m_9236_(), dir, fanPos, entityDistance);
            if (stacks == null) {
                return false;
            }
            if (stacks.isEmpty()) {
                entity.m_146870_();
                return false;
            }
            entity.m_32045_(stacks.remove(0));
            for (ItemStack additional : stacks) {
                ItemEntity entityIn = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
                entityIn.m_20256_(entity.m_20184_());
                entity.m_9236_().m_7967_((Entity)entityIn);
            }
            return true;
        }

        public TransportedItemStackHandlerBehaviour.TransportedResult applyProcessingHandlers(TransportedItemStack transported, Level world, FanProcessingType type, Direction dir, BlockPos fanPos, int blockDistance) {
            TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            if (transported.processedBy != type) {
                int processingTime;
                transported.processedBy = type;
                int timeModifierForStackSize = (transported.stack.m_41613_() - 1) / 16 + 1;
                transported.processingTime = processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
                if (!this.canProcess(transported.stack, world, dir, fanPos, blockDistance)) {
                    transported.processingTime = -1;
                }
                return ignore;
            }
            if (transported.processingTime == -1) {
                return ignore;
            }
            if (transported.processingTime-- > 0) {
                return ignore;
            }
            List<ItemStack> stacks = this.process(transported.stack, world, dir, fanPos, blockDistance);
            if (stacks == null) {
                return ignore;
            }
            ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
            for (ItemStack additional : stacks) {
                TransportedItemStack newTransported = transported.getSimilar();
                newTransported.stack = additional.m_41777_();
                transportedStacks.add(newTransported);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
        }

        private static int decrementProcessingTime(ItemEntity entity, FanProcessingType type) {
            CompoundTag processing;
            CompoundTag createData;
            CompoundTag nbt = entity.getPersistentData();
            if (!nbt.m_128441_("CreateData")) {
                nbt.m_128365_("CreateData", (Tag)new CompoundTag());
            }
            if (!(createData = nbt.m_128469_("CreateData")).m_128441_("Processing")) {
                createData.m_128365_("Processing", (Tag)new CompoundTag());
            }
            if (!(processing = createData.m_128469_("Processing")).m_128441_("Type") || AllFanProcessingTypes.parseLegacy((String)processing.m_128461_("Type")) != type) {
                ResourceLocation key = CreateBuiltInRegistries.FAN_PROCESSING_TYPE.m_7981_((Object)type);
                if (key == null) {
                    throw new IllegalArgumentException("Could not get id for FanProcessingType " + type + "!");
                }
                processing.m_128359_("Type", key.toString());
                int timeModifierForStackSize = (entity.m_32055_().m_41613_() - 1) / 16 + 1;
                int processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
                processing.m_128405_("Time", processingTime);
            }
            int value = processing.m_128451_("Time") - 1;
            processing.m_128405_("Time", value);
            return value;
        }
    }
}

