/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.init;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import fr.iglee42.cmr.CreateMoreRecipes;
import fr.iglee42.cmr.init.CMRRegistries;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CMRCreativeModeTabs {
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"cmr");
    public static final RegistryObject<CreativeModeTab> MAIN_TAB = TAB_REGISTER.register("tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.cmr")).withTabsBefore(new ResourceKey[]{AllCreativeModeTabs.BASE_CREATIVE_TAB.getKey()}).m_257737_(() -> CMRRegistries.SNOWMAN_COOLER.asStack()).m_257501_((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator(true, MAIN_TAB)).m_257652_());

    public static void register(IEventBus modEventBus) {
        TAB_REGISTER.register(modEventBus);
    }

    public static CreativeModeTab getBaseTab() {
        return (CreativeModeTab)MAIN_TAB.get();
    }

    private static class RegistrateDisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private static final Predicate<Item> IS_ITEM_3D_PREDICATE;
        private final boolean addItems;
        private final RegistryObject<CreativeModeTab> tabFilter;

        @OnlyIn(value=Dist.CLIENT)
        private static Predicate<Item> makeClient3dItemPredicate() {
            return item -> {
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                BakedModel model = itemRenderer.m_174264_(new ItemStack((ItemLike)item), null, null, 0);
                return model.m_7539_();
            };
        }

        public RegistrateDisplayItemsGenerator(boolean addItems, RegistryObject<CreativeModeTab> tabFilter) {
            this.addItems = addItems;
            this.tabFilter = tabFilter;
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemProviderEntry> simpleExclusions = List.of();
            List<ItemProviderEntry> tagDependentExclusions = List.of();
            for (ItemProviderEntry entry : simpleExclusions) {
                exclusions.add(entry.m_5456_());
            }
            for (ItemProviderEntry entry : tagDependentExclusions) {
                TagDependentIngredientItem item = (TagDependentIngredientItem)entry.get();
                if (!item.shouldHide()) continue;
                exclusions.add(entry.m_5456_());
            }
            return ((Set)exclusions)::contains;
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemProviderEntry, ItemProviderEntry> simpleBeforeOrderings = Map.of();
            Map<ItemProviderEntry, ItemProviderEntry> simpleAfterOrderings = Map.of();
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$2((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$3((List)orderings, arg_0, arg_1));
            PackageStyles.STANDARD_BOXES.forEach(arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$4((List)orderings, arg_0));
            return orderings;
        }

        private static Function<Item, ItemStack> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$5((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$6((Map)factories, arg_0);
        }

        private static Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$7((Map)visibilities, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$8((Map)visibilities, arg_0);
        }

        public void m_257865_(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
            Predicate<Item> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<Item, ItemStack> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            LinkedList<Item> items = new LinkedList<Item>();
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE.negate())));
            }
            items.addAll(this.collectBlocks(exclusionPredicate));
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE)));
            }
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : CreateMoreRecipes.REGISTRATE.getAll(Registries.f_256747_)) {
                Item item;
                if (!CreateRegistrate.isInCreativeTab((RegistryEntry)entry, this.tabFilter) || (item = ((Block)entry.get()).m_5456_()) == Items.f_41852_ || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : CreateMoreRecipes.REGISTRATE.getAll(Registries.f_256913_)) {
                Item item;
                if (!CreateRegistrate.isInCreativeTab((RegistryEntry)entry, this.tabFilter) || (item = (Item)entry.get()) instanceof BlockItem || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        private static void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                Item item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
            for (Item item : items) {
                output.m_246267_(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$8(Map visibilities, Item item) {
            CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$7(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
            visibilities.put(entry.m_5456_(), factory);
        }

        private static /* synthetic */ ItemStack lambda$makeStackFunc$6(Map factories, Item item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (ItemStack)factory.apply(item);
            }
            return new ItemStack((ItemLike)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$5(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.m_5456_(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$4(List orderings, PackageItem item) {
            orderings.add(ItemOrdering.after((Item)item, AllBlocks.PACKAGER.m_5456_()));
        }

        private static /* synthetic */ void lambda$makeOrderings$3(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.m_5456_(), otherEntry.m_5456_()));
        }

        private static /* synthetic */ void lambda$makeOrderings$2(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.m_5456_(), otherEntry.m_5456_()));
        }

        static {
            MutableObject isItem3d = new MutableObject(item -> false);
            if (CatnipServices.PLATFORM.getEnv().isClient()) {
                isItem3d.setValue(RegistrateDisplayItemsGenerator.makeClient3dItemPredicate());
            }
            IS_ITEM_3D_PREDICATE = (Predicate)isItem3d.getValue();
        }

        private record ItemOrdering(Item item, Item anchor, Type type) {
            public static ItemOrdering before(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }
}

