/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.blockspout;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.cmr.blockspout.BlockSpoutBlockEntity;
import fr.iglee42.cmr.init.CMRPartials;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class BlockSpoutRenderer
extends SmartBlockEntityRenderer<BlockSpoutBlockEntity> {
    private static final PartialModel[] BITS = new PartialModel[]{AllPartialModels.SPOUT_TOP, AllPartialModels.SPOUT_MIDDLE};

    public BlockSpoutRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BlockSpoutBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            level = Math.max(level, 0.175f);
            float min = 0.15625f;
            float max = min + 0.6875f;
            float yOffset = 0.6875f * level;
            ms.m_85836_();
            if (!top) {
                ms.m_252880_(0.0f, yOffset, 0.0f);
            } else {
                ms.m_252880_(0.0f, max - min, 0.0f);
            }
            ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, min, min - yOffset, min, max, min, max, buffer, ms, light, false, true);
            ms.m_85849_();
        }
        int processingTicks = be.processingTicks;
        float processingPT = (float)processingTicks - partialTicks;
        float squeeze = 0.0f;
        if (processingPT < 0.0f) {
            squeeze = 0.0f;
        } else if (processingPT <= 10.0f) {
            squeeze = Mth.m_14179_((float)(processingPT / 10.0f), (float)0.0f, (float)-1.0f);
        } else if (processingPT <= 90.0f) {
            squeeze = -1.0f;
        } else if (processingPT <= 100.0f) {
            squeeze = Mth.m_14179_((float)((100.0f - processingPT) / 10.0f), (float)0.0f, (float)-1.0f);
        }
        BlockState blockState = be.m_58900_();
        ((SuperByteBuffer)CachedBuffers.partial((PartialModel)CMRPartials.BLOCK_SPOUT_BOTTOM, (BlockState)blockState).translate(0.0f, squeeze / 2.0f, 0.0f)).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85836_();
        for (PartialModel bit : BITS) {
            CachedBuffers.partial((PartialModel)bit, (BlockState)be.m_58900_()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
        ms.m_85849_();
    }
}

