/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.blockspout;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import fr.iglee42.cmr.recipes.BlockSpoutingRecipe;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class BlockSpoutBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int TIME = 100;
    public int processingTicks = -1;
    public boolean sendSplash;
    SmartFluidTankBehaviour tank;
    public BlockSpoutingRecipe recipe;

    public BlockSpoutBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.processingTicks >= 0) {
            --this.processingTicks;
            this.notifyUpdate();
        }
        if (this.processingTicks > 7 && this.processingTicks < 93) {
            this.sendSplash = true;
            this.notifyUpdate();
        }
        if (this.processingTicks == 7 && this.recipe != null) {
            this.f_58857_.m_46961_(this.f_58858_.m_6625_(2), false);
            BlockState transformedBlock = this.recipe.transformBlock(this.f_58857_.m_8055_(this.f_58858_.m_6625_(2)));
            this.f_58857_.m_7731_(this.f_58858_.m_6625_(2), transformedBlock, 3);
            this.recipe.rollResults().forEach(stack -> Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_.m_6625_(2), (ItemStack)stack));
            FluidStack stack2 = this.getCurrentFluidInTank().copy();
            stack2.shrink(this.recipe.getRequiredFluid().getRequiredAmount());
            this.tank.getPrimaryHandler().setFluid(stack2);
            this.notifyUpdate();
            this.recipe = null;
        }
        if (this.recipe == null) {
            Optional<BlockSpoutingRecipe> foundRecipe = this.f_58857_.m_7465_().m_44013_(CMRRecipeTypes.BLOCK_SPOUTING.getType()).stream().filter(r -> {
                BlockSpoutingRecipe bsr = (BlockSpoutingRecipe)((ProcessingRecipe)r);
                return bsr.testBlock(this.f_58857_.m_8055_(this.f_58858_.m_6625_(2))) && bsr.getRequiredFluid().test(this.getCurrentFluidInTank());
            }).map(r -> (BlockSpoutingRecipe)((ProcessingRecipe)r)).findFirst();
            if (foundRecipe.isEmpty()) {
                this.recipe = null;
                return;
            }
            this.recipe = foundRecipe.get();
            this.processingTicks = 100;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void spawnParticles() {
        if (this.isVirtual()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        vec = vec.m_82492_(0.0, 2.0, 0.0);
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, this.getCurrentFluidInTank().getFluid().m_76145_().m_76188_());
        for (int i = 0; i < 2; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)1.5f);
            m = new Vec3(m.f_82479_, Math.abs(m.f_82480_), m.f_82481_);
            this.f_58857_.m_7107_((ParticleOptions)particle, vec.f_82479_, vec.f_82480_, vec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    protected void write(CompoundTag compoundTag, boolean clientPacket) {
        super.write(compoundTag, clientPacket);
        compoundTag.m_128405_("ProcessingTicks", this.processingTicks);
        if (this.sendSplash && clientPacket) {
            compoundTag.m_128379_("Splash", true);
            this.sendSplash = false;
        }
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
    }

    protected void read(CompoundTag compoundTag, boolean clientPacket) {
        super.read(compoundTag, clientPacket);
        this.processingTicks = compoundTag.m_128451_("ProcessingTicks");
        if (!clientPacket) {
            return;
        }
        if (compoundTag.m_128441_("Splash")) {
            this.spawnParticles();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, -2.0, 0.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }
}

