/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.autosmithing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.cmr.autosmithing.SmithingBehaviour;
import fr.iglee42.cmr.autosmithing.SmithingPressBlockEntity;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SmithingPressRenderer
extends KineticBlockEntityRenderer<SmithingPressBlockEntity> {
    public SmithingPressRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(SmithingPressBlockEntity be) {
        return true;
    }

    protected void renderSafe(SmithingPressBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderItem(be.templateInv.m_8020_(0), true, be, partialTicks, ms, buffer, light, overlay);
        this.renderItem(be.additionInv.m_8020_(0), false, be, partialTicks, ms, buffer, light, overlay);
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        BlockState blockState = be.m_58900_();
        SmithingBehaviour pressingBehaviour = be.getSmithingBehaviour();
        float renderedHeadOffset = pressingBehaviour.getRenderedHeadOffset(partialTicks) * 19.0f / 16.0f;
        SuperByteBuffer headRender = CachedBuffers.partialFacing((PartialModel)AllPartialModels.MECHANICAL_PRESS_HEAD, (BlockState)blockState, (Direction)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)));
        ((SuperByteBuffer)headRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    protected void renderItem(ItemStack heldItem, boolean isTemplate, SmithingPressBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (heldItem.m_41619_()) {
            return;
        }
        float headOffset = be.getSmithingBehaviour().getRenderedHeadOffset(partialTicks);
        float headPosY = headOffset * 19.0f / 16.0f;
        BlockState state = be.m_58900_();
        Vec3 handOffset = isTemplate ? this.getHandOffset(be, partialTicks, state) : (headPosY <= 0.325f ? Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_()).m_82490_(0.0) : this.getHandOffset(be, partialTicks, state).m_82520_(0.0, -0.05, 0.0));
        Vec3 offset = handOffset.m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_)).m_82520_(0.0, isTemplate || (double)headPosY > 0.325 ? 0.15 : -0.35, 0.0);
        ms.m_85836_();
        ms.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        Direction facing = Direction.DOWN;
        ms.m_252781_(Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)facing) + 180.0f));
        ms.m_252781_(Axis.f_252529_.m_252977_(270.0f));
        ms.m_252880_(0.0f, 0.0f, -0.6875f);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemDisplayContext transform = ItemDisplayContext.NONE;
        BakedModel bakedModel = itemRenderer.m_174264_(heldItem, be.m_58904_(), null, 0);
        boolean isBlockItem = heldItem.m_41720_() instanceof BlockItem && bakedModel.m_7539_();
        float scale = isBlockItem ? 0.734375f : 0.5f;
        ms.m_85841_(scale, scale, scale);
        transform = ItemDisplayContext.FIXED;
        if (!isTemplate) {
            ms.m_85841_(1.45f, 1.45f, 1.45f);
        }
        itemRenderer.m_115143_(heldItem, transform, false, ms, buffer, light, overlay, bakedModel);
        ms.m_85849_();
    }

    protected Vec3 getHandOffset(SmithingPressBlockEntity be, float partialTicks, BlockState blockState) {
        float distance = be.getSmithingBehaviour().getRenderedHeadOffset(partialTicks) * 19.0f / 16.0f;
        return Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_()).m_82490_((double)distance);
    }

    protected BlockState getRenderedBlockState(SmithingPressBlockEntity be) {
        return SmithingPressRenderer.shaft((Direction.Axis)SmithingPressRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

