/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.autosmithing;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.cmr.autosmithing.SmithingBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingPressBlockEntity
extends BasinOperatingBlockEntity
implements SmithingBehaviour.SmithingBehaviourSpecifics {
    private static final Object smithingRecipesKey = new Object();
    public SmithingBehaviour smithingBehaviour;
    protected SmartInventory templateInv = new SmartInventory(1, (SyncedBlockEntity)this);
    protected SmartInventory additionInv;
    protected LazyOptional<IItemHandler> templateCapability = LazyOptional.of(() -> this.templateInv);
    protected LazyOptional<IItemHandler> additionCapability;

    public SmithingPressBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.additionInv = new SmartInventory(1, (SyncedBlockEntity)this);
        this.additionCapability = LazyOptional.of(() -> this.additionInv);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return Objects.equals(side, Direction.DOWN) || Objects.equals(side, Direction.UP) ? this.templateCapability.cast() : this.additionCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.smithingBehaviour = new SmithingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.smithingBehaviour);
    }

    public void invalidate() {
        this.templateCapability.invalidate();
        this.additionCapability.invalidate();
        super.invalidate();
    }

    public void destroy() {
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.templateInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.additionInv);
        super.destroy();
    }

    public SmithingBehaviour getSmithingBehaviour() {
        return this.smithingBehaviour;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Template", (Tag)this.templateInv.serializeNBT());
        compound.m_128365_("Addition", (Tag)this.additionInv.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.templateInv.deserializeNBT(compound.m_128469_("Template"));
        this.additionInv.deserializeNBT(compound.m_128469_("Addition"));
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<SmithingRecipe> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        ItemStackHandler handler = new ItemStackHandler(3);
        handler.setStackInSlot(0, this.templateInv.getStackInSlot(0));
        handler.setStackInSlot(1, input.stack);
        handler.setStackInSlot(2, this.additionInv.getStackInSlot(0));
        SimpleContainer inventory = new SimpleContainer(handler.getSlots());
        ItemStack output = recipe.get().m_5874_((Container)inventory, this.f_58857_.m_9598_());
        if (simulate) {
            return !output.m_41619_();
        }
        this.smithingBehaviour.particleItems.add(input.stack);
        if (!output.m_41619_()) {
            this.templateInv.extractItem(0, 1, false);
            this.additionInv.extractItem(0, 1, false);
            outputList.add(output);
            return true;
        }
        return false;
    }

    @Override
    public void onPressingCompleted() {
        this.basinChecker.scheduleUpdate();
    }

    public Optional<SmithingRecipe> getRecipe(ItemStack item) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        ItemStackHandler handler = new ItemStackHandler(3);
        handler.setStackInSlot(0, this.templateInv.getStackInSlot(0));
        handler.setStackInSlot(1, item);
        handler.setStackInSlot(2, this.additionInv.getStackInSlot(0));
        SimpleContainer inventory = new SimpleContainer(handler.getSlots());
        for (int i = 0; i < handler.getSlots(); ++i) {
            inventory.m_6836_(i, handler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44113_, (Container)inventory, this.f_58857_);
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    protected Object getRecipeCacheKey() {
        return smithingRecipesKey;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    protected void onBasinRemoved() {
        this.smithingBehaviour.particleItems.clear();
        this.smithingBehaviour.running = false;
        this.smithingBehaviour.runningTicks = 0;
        this.sendData();
    }

    protected boolean isRunning() {
        return this.smithingBehaviour.running;
    }

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.COMPACTING);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe instanceof SmithingRecipe;
    }

    public SmartInventory getInvForSide(Direction direction) {
        if (direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN)) {
            return this.templateInv;
        }
        return this.additionInv;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.templateInv.m_7983_()) {
            CreateLang.translate((String)"tooltip.deployer.contains", (Object[])new Object[]{Component.m_237115_((String)this.templateInv.getStackInSlot(0).m_41778_()).getString(), this.templateInv.getStackInSlot(0).m_41613_()}).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        if (!this.additionInv.m_7983_()) {
            CreateLang.translate((String)"tooltip.deployer.contains", (Object[])new Object[]{Component.m_237115_((String)this.additionInv.getStackInSlot(0).m_41778_()).getString(), this.additionInv.getStackInSlot(0).m_41613_()}).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

