/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.autosmithing;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import fr.iglee42.cmr.autosmithing.SmithingCallbacks;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeItemStack;

public class SmithingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int ENTITY_SCAN = 10;
    public List<ItemStack> particleItems = new ArrayList<ItemStack>();
    public SmithingBehaviourSpecifics specifics;
    public int prevRunningTicks;
    public int runningTicks;
    public boolean running;
    public boolean finished;
    int entityScanCooldown;

    public <T extends SmartBlockEntity> SmithingBehaviour(T be) {
        super(be);
        this.specifics = (SmithingBehaviourSpecifics)be;
        this.entityScanCooldown = 10;
        this.whenItemEnters((s, i) -> SmithingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> SmithingCallbacks.whenItemHeld(s, i, this));
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.finished = compound.m_128471_("Finished");
        this.prevRunningTicks = this.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
        if (clientPacket) {
            NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("ParticleItems", 10), c -> this.particleItems.add(ItemStack.m_41712_((CompoundTag)c)));
            this.spawnParticles();
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128379_("Finished", this.finished);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128365_("ParticleItems", (Tag)NBTHelper.writeCompoundList(this.particleItems, IForgeItemStack::serializeNBT));
            this.particleItems.clear();
        }
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.m_14179_((float)(partialTicks * 2.0f), (float)this.prevRunningTicks, (float)runningTicks);
        if (runningTicks < 160) {
            return (float)Mth.m_14008_((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0);
        }
        return Mth.m_14036_((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f);
    }

    public void start() {
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.particleItems.clear();
        this.blockEntity.sendData();
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        if (!this.running || level == null) {
            if (level != null && !level.f_46443_ && this.specifics.getKineticSpeed() == 0.0f) {
                return;
            }
            return;
        }
        if (level.f_46443_ && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.specifics.getKineticSpeed() != 0.0f) {
            if (level.m_8055_(worldPosition.m_6625_(2)).m_60827_() == SoundType.f_56745_) {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(level, (Vec3i)worldPosition);
            } else {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(level, (Vec3i)worldPosition, 0.5f, 0.75f + Math.abs(this.specifics.getKineticSpeed()) / 1024.0f);
            }
            if (!level.f_46443_) {
                this.blockEntity.sendData();
            }
        }
        if (!level.f_46443_ && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            this.particleItems.clear();
            this.specifics.onPressingCompleted();
            this.blockEntity.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (level.f_46443_ && !this.blockEntity.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    protected void spawnParticles() {
        if (this.particleItems.isEmpty()) {
            return;
        }
        BlockPos worldPosition = this.getPos();
        this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.m_6625_(2)).m_82520_(0.0, 0.5, 0.0), (ItemStack)stack));
        this.particleItems.clear();
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack) {
        this.makePressingParticleEffect(pos, stack, this.specifics.getParticleAmount());
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack, int amount) {
        Level level = this.getWorld();
        if (level == null || !level.f_46443_) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)0.125f).m_82542_(1.0, 0.0, 1.0);
            motion = motion.m_82520_(0.0, amount != 1 ? 0.125 : 0.0625, 0.0);
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_ - 0.25, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public static interface SmithingBehaviourSpecifics {
        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public void onPressingCompleted();

        public int getParticleAmount();

        public float getKineticSpeed();
    }
}

