/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.lathe;

import com.negodya1.vintageimprovements.VintageLang;
import com.negodya1.vintageimprovements.content.kinetics.lathe.LatheMenu;
import com.negodya1.vintageimprovements.content.kinetics.lathe.LatheMovingBlock;
import com.negodya1.vintageimprovements.content.kinetics.lathe.LatheRotatingBlockEntity;
import com.negodya1.vintageimprovements.content.kinetics.lathe.TurningRecipe;
import com.negodya1.vintageimprovements.content.kinetics.lathe.recipe_card.RecipeCardItem;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LatheMovingBlockEntity
extends KineticBlockEntity
implements MenuProvider,
IHaveGoggleInformation {
    public SmartInventory recipeSlot = new SmartInventory(1, (SyncedBlockEntity)this, 1, false);
    public TurningRecipe currentRecipe;
    public int index = -1;

    public LatheMovingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean manualMode() {
        return this.recipeSlot.m_7983_();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("RecipeSlot", (Tag)this.recipeSlot.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.recipeSlot.deserializeNBT(compound.m_128469_("RecipeSlot"));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(0.125);
    }

    public void tick() {
        super.tick();
    }

    public void invalidate() {
        super.invalidate();
    }

    public void destroy() {
        super.destroy();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return LatheMenu.create(id, inv, this);
    }

    public Component m_5446_() {
        return VintageLang.translateDirect("gui.lathe.title", new Object[0]);
    }

    public List<TurningRecipe> getRecipes() {
        LatheRotatingBlockEntity be = (LatheRotatingBlockEntity)this.f_58857_.m_7702_(LatheMovingBlock.getMaster((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be == null) {
            return new ArrayList<TurningRecipe>();
        }
        return be.getRecipes();
    }

    public void resetRecipe() {
        LatheRotatingBlockEntity be = (LatheRotatingBlockEntity)this.f_58857_.m_7702_(LatheMovingBlock.getMaster((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        be.resetRecipe();
    }

    public int getIndex(ItemStack ingredient) {
        if (this.recipeSlot.m_7983_()) {
            return -1;
        }
        if (this.recipeSlot.getStackInSlot(0).m_41720_() instanceof RecipeCardItem) {
            if (!RecipeCardItem.haveRecipe(this.recipeSlot.getStackInSlot(0))) {
                return -1;
            }
            if (RecipeCardItem.getFrequencyItems(this.recipeSlot.getStackInSlot(0)).getStackInSlot(0).m_150930_(ingredient.m_41720_())) {
                int i = 0;
                for (TurningRecipe recipe : this.getRecipes()) {
                    if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(RecipeCardItem.getResultItems(this.recipeSlot.getStackInSlot(0)).getStackInSlot(0).m_41720_())) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public int getTemporaryIndex() {
        return this.index;
    }

    public SmartInventory getInputInventory() {
        LatheRotatingBlockEntity be = (LatheRotatingBlockEntity)this.f_58857_.m_7702_(LatheMovingBlock.getMaster((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be == null) {
            return new SmartInventory(1, (SyncedBlockEntity)this);
        }
        return be.inputInv;
    }

    public Optional<TurningRecipe> getTemporaryRecipe() {
        if (this.currentRecipe == null) {
            return Optional.empty();
        }
        Optional<TurningRecipe> result = Optional.of(this.currentRecipe);
        this.currentRecipe = null;
        this.index = -1;
        return result;
    }
}

