/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.grinder;

import com.google.common.collect.ImmutableList;
import com.negodya1.vintageimprovements.VintageLang;
import com.negodya1.vintageimprovements.VintageRecipes;
import com.negodya1.vintageimprovements.content.kinetics.grinder.GrinderFilterSlot;
import com.negodya1.vintageimprovements.content.kinetics.grinder.PolishingRecipe;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancementBehaviour;
import com.negodya1.vintageimprovements.foundation.advancement.VintageAdvancements;
import com.negodya1.vintageimprovements.infrastructure.config.VintageConfig;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrinderBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private static final Object polishingRecipesKey = new Object();
    public ProcessingInventory inventory;
    private int recipeIndex;
    private final LazyOptional<IItemHandler> invProvider;
    private FilteringBehaviour filtering;
    private VintageAdvancementBehaviour advancementBehaviour;
    private ItemStack playEvent;
    private int textureType;

    public GrinderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.invProvider = LazyOptional.of(() -> this.inventory);
        this.playEvent = ItemStack.f_41583_;
        this.textureType = (Integer)VintageConfig.common().defaultBeltGrinderSkin.get();
    }

    public boolean canCraft(ItemStack stack) {
        List recipes = this.f_58857_.m_7465_().m_44013_(VintageRecipes.POLISHING.getType());
        for (PolishingRecipe recipe : recipes) {
            if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_) != stack) continue;
            return true;
        }
        return false;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new GrinderFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("RecipeIndex", this.recipeIndex);
        compound.m_128405_("TextureType", this.textureType);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.m_41619_()) {
            return;
        }
        compound.m_128365_("PlayEvent", (Tag)this.playEvent.serializeNBT());
        this.playEvent = ItemStack.f_41583_;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeIndex = compound.m_128451_("RecipeIndex");
        this.textureType = compound.m_128451_("TextureType");
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.m_41619_()) {
            this.spawnEventParticles(this.playEvent);
            this.playEvent = ItemStack.f_41583_;
            AllSoundEvents.SANDING_SHORT.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
        }
    }

    private void findEntities() {
        if (!this.inventory.isEmpty()) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        AABB searchArea = new AABB(center.m_82520_(0.0, 0.5, 0.0), center.m_82520_(0.0, -0.5, 0.0)).m_82400_((double)0.45f);
        for (ItemEntity itemEntity : this.f_58857_.m_45976_(ItemEntity.class, searchArea)) {
            this.insertItem(itemEntity);
        }
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        if (this.inventory.isEmpty()) {
            this.findEntities();
        }
        float processingSpeed = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getStackInSlot(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.m_122366_((double)itemMovement.f_82479_, (double)itemMovement.f_82480_, (double)itemMovement.f_82481_);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.m_122424_(), false)) == null) continue;
            if (tryExportingToBeltFunnel.m_41613_() != stack.m_41613_()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.m_41619_()) continue;
            return;
        }
        BlockPos nextPos = this.f_58858_.m_121955_((Vec3i)BlockPos.m_274446_((Position)itemMovement));
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_41619_() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack, false)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.m_6596_();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(itemMovement.m_82490_(0.5).m_82520_(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.m_82490_(0.0625).m_82520_(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            ItemEntity entityIn = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_, outPos.f_82481_, stack);
            entityIn.m_20256_(outMotion);
            this.f_58857_.m_7967_((Entity)entityIn);
        }
        this.inventory.clear();
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.inventory.remainingTime = -1.0f;
        this.m_6596_();
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.invProvider.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.invProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Object particleData = null;
        particleData = stack.m_41720_() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, stack);
        RandomSource r = this.f_58857_.f_46441_;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.25, 0.0), (RandomSource)r, (float)0.125f);
            this.f_58857_.m_7106_((ParticleOptions)particleData, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82480_);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        ItemParticleOption particleData = null;
        float speed = 1.0f;
        if (stack.m_41720_() instanceof BlockItem) {
            particleData = new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_());
        } else {
            particleData = new ItemParticleOption(ParticleTypes.f_123752_, stack);
            speed = 0.125f;
        }
        RandomSource r = this.f_58857_.f_46441_;
        Vec3 vec = this.getItemMovementVec();
        Vec3 pos = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.f_58857_.m_7106_((ParticleOptions)particleData, pos.m_7096_() + -vec.f_82479_ * (double)offset, pos.m_7098_() + (double)0.45f, pos.m_7094_() + -vec.f_82481_ * (double)offset, -vec.f_82479_ * (double)speed, (double)(r.m_188501_() * speed), -vec.f_82481_ * (double)speed);
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.WEST || this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.EAST;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 0 : 1)), 0.0, (double)(offset * (alongX ? -1 : 0)));
    }

    public int getCurrentSpeedMode() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        if (Mth.m_14154_((float)this.getSpeed()) <= (float)((Integer)VintageConfig.server().recipes.lowSpeedValue.get()).intValue()) {
            return 1;
        }
        if (Mth.m_14154_((float)this.getSpeed()) <= (float)((Integer)VintageConfig.server().recipes.mediumSpeedValue.get()).intValue()) {
            return 2;
        }
        return 3;
    }

    private void applyRecipe() {
        Recipe<?> recipe;
        List<Recipe<?>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        if ((recipe = recipes.get(this.recipeIndex)).m_6671_() == AllRecipeTypes.SANDPAPER_POLISHING.getType()) {
            if ((Integer)VintageConfig.server().recipes.speedLimitsForSandpaperPolishingRecipes.get() != 0) {
                int speed = (int)Math.abs(this.getSpeed());
                boolean wrongLimit = false;
                if ((Integer)VintageConfig.server().recipes.speedLimitsForSandpaperPolishingRecipes.get() == 1 && speed > (Integer)VintageConfig.server().recipes.lowSpeedValue.get()) {
                    wrongLimit = true;
                }
                if ((Integer)VintageConfig.server().recipes.speedLimitsForSandpaperPolishingRecipes.get() == 2 && (speed > (Integer)VintageConfig.server().recipes.mediumSpeedValue.get() || speed <= (Integer)VintageConfig.server().recipes.lowSpeedValue.get())) {
                    wrongLimit = true;
                }
                if ((Integer)VintageConfig.server().recipes.speedLimitsForSandpaperPolishingRecipes.get() == 3 && speed <= (Integer)VintageConfig.server().recipes.mediumSpeedValue.get()) {
                    wrongLimit = true;
                }
                if (wrongLimit) {
                    if (((Boolean)VintageConfig.server().recipes.destroyOnWrongGrinderSpeed.get()).booleanValue()) {
                        this.inventory.clear();
                    }
                    return;
                }
            }
            int rolls = this.inventory.getStackInSlot(0).m_41613_();
            this.inventory.clear();
            ArrayList list = new ArrayList();
            for (int roll = 0; roll < rolls; ++roll) {
                List results = new LinkedList();
                if (recipe instanceof SandPaperPolishingRecipe) {
                    SandPaperPolishingRecipe sandRecipe = (SandPaperPolishingRecipe)recipe;
                    results = sandRecipe.rollResults();
                }
                for (int i = 0; i < results.size(); ++i) {
                    ItemStack stack = (ItemStack)results.get(i);
                    ItemHelper.addToList((ItemStack)stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
            this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_BELT_GRINDER);
            return;
        }
        if (recipe instanceof PolishingRecipe) {
            PolishingRecipe polishingRecipe = (PolishingRecipe)recipe;
            if (polishingRecipe.speedLimits != 0) {
                int speed = (int)Math.abs(this.getSpeed());
                boolean wrongLimit = false;
                if (polishingRecipe.speedLimits == 1 && speed > (Integer)VintageConfig.server().recipes.lowSpeedValue.get()) {
                    wrongLimit = true;
                }
                if (polishingRecipe.speedLimits == 2 && (speed > (Integer)VintageConfig.server().recipes.mediumSpeedValue.get() || speed <= (Integer)VintageConfig.server().recipes.lowSpeedValue.get())) {
                    wrongLimit = true;
                }
                if (polishingRecipe.speedLimits == 3 && speed <= (Integer)VintageConfig.server().recipes.mediumSpeedValue.get()) {
                    wrongLimit = true;
                }
                if (wrongLimit) {
                    if (((Boolean)VintageConfig.server().recipes.destroyOnWrongGrinderSpeed.get()).booleanValue() || polishingRecipe.fragile) {
                        this.inventory.clear();
                    }
                    return;
                }
            }
            int rolls = this.inventory.getStackInSlot(0).m_41613_();
            this.inventory.clear();
            ArrayList list = new ArrayList();
            for (int roll = 0; roll < rolls; ++roll) {
                List results = polishingRecipe.rollResults();
                for (int i = 0; i < results.size(); ++i) {
                    ItemStack stack = (ItemStack)results.get(i);
                    ItemHelper.addToList((ItemStack)stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
            this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_BELT_GRINDER);
        }
    }

    private List<? extends Recipe<?>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(0), VintageRecipes.POLISHING.getType(), PolishingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(((PolishingRecipe)((Object)assemblyRecipe.get())).m_8043_(this.f_58857_.m_9598_()))) {
            return ImmutableList.of((Object)((Object)((PolishingRecipe)((Object)assemblyRecipe.get()))));
        }
        Predicate types = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{VintageRecipes.POLISHING.getType(), (Boolean)VintageConfig.server().recipes.allowSandpaperPolishingOnGrinder.get() != false ? AllRecipeTypes.SANDPAPER_POLISHING.getType() : null});
        List startedSearch = RecipeFinder.get((Object)polishingRecipesKey, (Level)this.f_58857_, (Predicate)types);
        startedSearch = startedSearch.stream().filter(RecipeConditions.outputMatchesFilter((FilteringBehaviour)this.filtering)).filter(RecipeConditions.firstIngredientMatches((ItemStack)this.inventory.getStackInSlot(0))).filter(r -> !VintageRecipes.shouldIgnoreInAutomation(r)).collect(Collectors.toList());
        ArrayList<Recipe> grinder = new ArrayList<Recipe>();
        ArrayList<Recipe> grinderWrongSpeed = new ArrayList<Recipe>();
        ArrayList<Recipe> sandpaper = new ArrayList<Recipe>();
        for (Recipe recipe : startedSearch) {
            if (recipe instanceof PolishingRecipe) {
                PolishingRecipe re = (PolishingRecipe)recipe;
                if (re.getSpeedLimits() == this.getCurrentSpeedMode()) {
                    grinder.add(recipe);
                    continue;
                }
                grinderWrongSpeed.add(recipe);
                continue;
            }
            sandpaper.add(recipe);
        }
        if (!grinder.isEmpty()) {
            return grinder;
        }
        if (!grinderWrongSpeed.isEmpty()) {
            return grinderWrongSpeed;
        }
        return sandpaper;
    }

    public void insertItem(ItemEntity entity) {
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.inventory.clear();
        ItemStack remainder = this.inventory.insertItem(0, entity.m_32055_().m_41777_(), false);
        if (remainder.m_41619_()) {
            entity.m_146870_();
        } else {
            entity.m_32045_(remainder);
        }
    }

    public void start(ItemStack inserted) {
        Recipe<?> recipe;
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        List<Recipe<?>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex)) instanceof PolishingRecipe) {
            time = ((PolishingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.m_41613_() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        LangBuilder reqSpd = VintageLang.translate("gui.goggles.current_speed", new Object[0]).add(CreateLang.text((String)" "));
        int speedMode = Math.abs(this.getSpeed()) <= (float)((Integer)VintageConfig.server().recipes.lowSpeedValue.get()).intValue() ? 1 : (Math.abs(this.getSpeed()) <= (float)((Integer)VintageConfig.server().recipes.mediumSpeedValue.get()).intValue() ? 2 : 3);
        switch (speedMode) {
            case 2: {
                reqSpd.add(VintageLang.translate("gui.goggles.medium", new Object[0])).style(ChatFormatting.YELLOW).forGoggles(tooltip);
                break;
            }
            case 3: {
                reqSpd.add(VintageLang.translate("gui.goggles.high", new Object[0])).style(ChatFormatting.RED).forGoggles(tooltip);
                break;
            }
            default: {
                reqSpd.add(VintageLang.translate("gui.goggles.low", new Object[0])).style(ChatFormatting.GREEN).forGoggles(tooltip);
            }
        }
        return true;
    }

    public int getTextureType() {
        return this.textureType;
    }

    public boolean addTexture(ItemStack items) {
        if (items.m_41619_()) {
            return false;
        }
        if (!(items.m_41720_() instanceof SandPaperItem)) {
            return false;
        }
        this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.BELT_GRINDER_SKIN_CHANGE);
        switch (items.m_41720_().m_5524_()) {
            case "item.create.sand_paper": {
                this.textureType = 0;
                return true;
            }
            case "item.create.red_sand_paper": {
                this.textureType = 1;
                return true;
            }
            case "item.createaddition.diamond_grit_sandpaper": 
            case "item.create_so.diamond_sandpaper": {
                this.textureType = 2;
                return true;
            }
            case "item.create_so.iron_sandpaper": {
                this.textureType = 3;
                return true;
            }
            case "item.create_so.obsidian_sandpaper": {
                this.textureType = 4;
                return true;
            }
        }
        return false;
    }
}

