/*
 * Decompiled with CFR 0.152.
 */
package com.negodya1.vintageimprovements.content.kinetics.coiling;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.negodya1.vintageimprovements.VintagePartialModels;
import com.negodya1.vintageimprovements.content.kinetics.coiling.CoilingBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CoilingRenderer
extends KineticBlockEntityRenderer<CoilingBlockEntity> {
    public CoilingRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CoilingBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderParts(be, ms, buffer, light);
        this.renderSpring(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.m_58904_())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderParts(CoilingBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        float speed = -Math.abs(be.getSpeed());
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float angle = time * speed * 6.0f / 10.0f % 360.0f;
        BlockState blockState = be.m_58900_();
        PartialModel partial = VintagePartialModels.COILING_WHEEL;
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)partial, (BlockState)blockState);
        this.rotateWheel(superBuffer, angle, (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_));
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    private SuperByteBuffer rotateWheel(SuperByteBuffer buffer, float angle, Direction facing) {
        float pivotX = 0.3125f;
        float pivotY = 0.65625f;
        float pivotZ = 0.71875f;
        buffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122428_())), Direction.UP);
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotate(AngleHelper.rad((double)angle), Direction.EAST);
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        return buffer;
    }

    private SuperByteBuffer rotateSpring(SuperByteBuffer buffer, float angle, Direction facing) {
        float pivotX = 1.0625f;
        float pivotY = 0.59375f;
        float pivotZ = 0.46875f;
        buffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122428_())), Direction.UP);
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotate(AngleHelper.rad((double)angle), Direction.EAST);
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        return buffer;
    }

    protected void renderShaft(CoilingBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        PartialModel partial = AllPartialModels.SHAFT_HALF;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)partial, (BlockState)blockState);
        CoilingRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light);
        superBuffer.rotateCentered(AngleHelper.rad((double)(be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH ? 0.0 : (be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.SOUTH ? 180.0 : (be.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_) == Direction.EAST ? 270.0 : 90.0)))), Direction.UP);
        superBuffer.renderInto(ms, vb);
    }

    protected void renderSpring(CoilingBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.inventory.isEmpty()) {
            ms.m_85836_();
            boolean moving = be.inventory.recipeDuration != 0.0f;
            float offset = moving ? be.inventory.remainingTime / be.inventory.recipeDuration : 0.0f;
            float processingSpeed = Mth.m_14036_((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = Mth.m_14036_((float)(offset + (-partialTicks + 0.5f) * processingSpeed / be.inventory.recipeDuration), (float)0.05f, (float)0.75f);
                if (!be.inventory.appliedRecipe) {
                    offset += 1.0f;
                }
                offset /= 2.0f;
            }
            if (be.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            offset = 0.3f - offset;
            int i = 0;
            if (i < be.inventory.getSlots()) {
                BlockState blockState = be.m_58900_();
                PartialModel partial = VintagePartialModels.COILING_SPRING;
                SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)partial, (BlockState)blockState);
                float speed = -Math.abs(be.getSpeed());
                float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
                float angle = time * speed * 6.0f / 10.0f % 360.0f;
                this.rotateSpring(superBuffer, angle, (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_));
                superBuffer.rotateCentered((float)Math.PI, Direction.UP);
                superBuffer.translate(offset, 0.0f, 0.0f);
                superBuffer.color(be.getSpringColor()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
            }
            ms.m_85849_();
        }
    }
}

