/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.init;

import com.mafuyu404.taczaddon.init.VirtualContainerLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class DropDown
extends AbstractWidget {
    private final List<Component> options = new ArrayList<Component>();
    private boolean isExpanded = false;
    private int selectedIndex = 0;
    private int scrollOffset = 0;
    private final int itemHeight = 20;
    private final int maxVisibleItems = 10;
    private static final int SCROLL_BAR_WIDTH = 4;

    public DropDown(int x, int y, int width) {
        super(x, y, width, 220, (Component)Component.m_237119_());
    }

    public void addOption(Component option) {
        this.options.add(option);
    }

    public int getSelected() {
        return this.selectedIndex;
    }

    public void setSelected(int index) {
        if (index >= 0 && index < this.options.size()) {
            this.selectedIndex = index;
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 20, -16777216);
        guiGraphics.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, 20, -1);
        if (!this.options.isEmpty()) {
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.options.get(this.selectedIndex), this.m_252754_() + 5, this.m_252907_() + 6, 0xFFFFFF);
        }
        if (this.isExpanded) {
            int totalHeight = Math.min(this.options.size(), 10) * 20;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + 20, this.m_252754_() + this.f_93618_, this.m_252907_() + 20 + totalHeight, -16777216);
            int itemsToShow = Math.min(this.options.size() - this.scrollOffset, 10);
            for (int i = 0; i < itemsToShow; ++i) {
                int actualIndex = i + this.scrollOffset;
                int yPos = this.m_252907_() + 20 + i * 20;
                boolean isHovered = this.isMouseOverOption(mouseX, mouseY, i);
                if (isHovered) {
                    guiGraphics.m_280509_(this.m_252754_(), yPos, this.m_252754_() + this.f_93618_, yPos + 20, -2143009724);
                }
                guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.options.get(actualIndex), this.m_252754_() + 5, yPos + 6, 0xFFFFFF);
            }
            if (this.options.size() > 10) {
                this.drawScrollBar(guiGraphics, totalHeight);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY) && !this.isExpanded) {
            return false;
        }
        if (button == 0) {
            if (!this.isExpanded) {
                this.isExpanded = true;
                this.scrollOffset = 0;
            } else {
                for (int i = 0; i < Math.min(this.options.size(), 10); ++i) {
                    if (!this.isMouseOverOption(mouseX, mouseY, i)) continue;
                    this.selectedIndex = i + this.scrollOffset;
                    this.isExpanded = false;
                    ((VirtualContainerLoader)Minecraft.m_91087_().f_91080_).refreshRecipes(this.options.get(i).getString(), true);
                    return true;
                }
                this.isExpanded = false;
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void drawScrollBar(GuiGraphics guiGraphics, int totalHeight) {
        int contentHeight = this.options.size() * 20;
        int visibleHeight = 200;
        float scrollRatio = (float)this.scrollOffset / (float)(this.options.size() - 10);
        int scrollBarHeight = (int)((float)visibleHeight * (float)visibleHeight / (float)contentHeight);
        int scrollY = this.m_252907_() + 20 + (int)(scrollRatio * (float)(totalHeight - scrollBarHeight));
        guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 4 - 1, this.m_252907_() + 20, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + 20 + totalHeight, -10066330);
        guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 4 - 1, scrollY, this.m_252754_() + this.f_93618_ - 1, scrollY + scrollBarHeight, -5592406);
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    private boolean isMouseOverOption(double mouseX, double mouseY, int visibleIndex) {
        return mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_ - 4) && mouseY >= (double)(this.m_252907_() + 20 + visibleIndex * 20) && mouseY <= (double)(this.m_252907_() + 20 + (visibleIndex + 1) * 20);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isExpanded) {
            int newScrollOffset = (int)((double)this.scrollOffset - Math.signum(delta));
            int maxScroll = Math.max(0, this.options.size() - 10);
            this.scrollOffset = DropDown.clamp(newScrollOffset, 0, maxScroll);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }
}

