/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.init;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="taczaddon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec.ConfigValue<Boolean> BETTER_AIM_CAMERA;
    public static final ForgeConfigSpec.ConfigValue<Boolean> BETTER_GUNSMITHTABLE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GUNSMITHTABLE_CRAFT_TOAST;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GUNSMITHTABLE_MEMORY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GUNSMITHTABLE_CONTAINER_READER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHOW_ATTACHMENT_ATTRIBUTE;
    public static final ForgeConfigSpec.ConfigValue<Integer> LESS_ALLOW_GUN;
    public static final ForgeConfigSpec.ConfigValue<Integer> GUNSMITHTABLE_MASS_CRAFT_TIME;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> MELEE_WEAPON_LIST;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec SPEC;
    private static Set<String> ITEM_BLACKLIST;

    private static void updateItemBlacklist() {
        ITEM_BLACKLIST.clear();
        for (String itemId : (List)MELEE_WEAPON_LIST.get()) {
            ITEM_BLACKLIST.add(new ResourceLocation(itemId).toString());
        }
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.updateItemBlacklist();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.updateItemBlacklist();
        }
    }

    public static boolean isItemInBlacklist(ItemStack itemStack) {
        return ITEM_BLACKLIST.contains(itemStack.m_41783_().m_128461_("GunId"));
    }

    public static boolean enableBetterAimCamera() {
        return (Boolean)BETTER_AIM_CAMERA.get();
    }

    public static boolean enableBetterGunSmithTable() {
        return (Boolean)BETTER_GUNSMITHTABLE.get();
    }

    public static boolean enableGunSmithTableCraftToast() {
        return (Boolean)GUNSMITHTABLE_CRAFT_TOAST.get();
    }

    public static boolean enableGunSmithTableMemory() {
        return (Boolean)GUNSMITHTABLE_MEMORY.get();
    }

    public static boolean enableGunSmithTableContainerReader() {
        return (Boolean)GUNSMITHTABLE_CONTAINER_READER.get();
    }

    public static int getAllowGunAmount() {
        return (Integer)LESS_ALLOW_GUN.get();
    }

    public static int getMassCraftTime() {
        return (Integer)GUNSMITHTABLE_MASS_CRAFT_TIME.get();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        ITEM_BLACKLIST = new HashSet<String>();
        BUILDER.push("Melee Setting");
        MELEE_WEAPON_LIST = BUILDER.comment("\u5217\u8868\u91cc\u7684\u67aa\u68b0\u4f1a\u4f5c\u4e3a\u8fd1\u6218\u6b66\u5668\u4f7f\u7528\uff0c\u5f00\u706b\u5c06\u88ab\u66ff\u6362\u4e3a\u8fd1\u6218\u653b\u51fb\u3002\u4f60\u53ef\u4ee5\u6309F3+H\u6253\u5f00\u9ad8\u7ea7\u63d0\u793a\u6846\uff0c\u67e5\u770b\u7269\u54c1\u7684GunId\u6807\u7b7e\uff0c\u5c31\u50cf\u793a\u4f8b\u7684\u90a3\u6837\u3002").defineList("MeleeWeaponList", List.of("tacz:type_82", "tacz:type_83"), entry -> entry instanceof String);
        BUILDER.pop();
        BUILDER.push("Camera Setting");
        BETTER_AIM_CAMERA = BUILDER.comment("\u5f00\u542f\u540e\uff0c\u5982\u679c\u6b63\u5904\u4e8e\u975e\u7b2c\u4e00\u4eba\u79f0\u89c6\u89d2\uff0c\u4f7f\u7528\u67aa\u68b0\u7784\u51c6\u5c06\u81ea\u52a8\u5207\u6362\u4e3a\u7b2c\u4e00\u4eba\u79f0\uff0c\u53d6\u6d88\u7784\u51c6\u540e\u5207\u6362\u4e3a\u539f\u89c6\u89d2\u3002").define("enableBetterAimCamera", true);
        BUILDER.pop();
        BUILDER.push("GunSmithTable Setting");
        BETTER_GUNSMITHTABLE = BUILDER.comment("\u5f00\u542f\u540e\uff0c\u6301\u67aa\u4e0e\u67aa\u68b0\u5de5\u4f5c\u53f0\u4e92\u52a8\u5c06\u53ea\u663e\u793a\u53ef\u7528\u914d\u4ef6\u548c\u5f39\u836f\u3002").define("enableRecipeFilter", true);
        GUNSMITHTABLE_CRAFT_TOAST = BUILDER.comment("\u5f00\u542f\u540e\uff0c\u5728\u67aa\u68b0\u5de5\u4f5c\u53f0\u5236\u9020\u4e1c\u897f\u65f6\u4f1a\u5f39\u51fa\u76f8\u5173\u7269\u54c1\u63d0\u793a\u3002").define("enableCraftToast", true);
        GUNSMITHTABLE_MEMORY = BUILDER.comment("\u5f00\u542f\u540e\uff0c\u6253\u5f00\u67aa\u68b0\u5de5\u4f5c\u53f0\u65f6\u5c06\u4f1a\u8df3\u8f6c\u5230\u4e0a\u6b21\u6d4f\u89c8\u7684\u4f4d\u7f6e\u3002").define("enableMemory", true);
        GUNSMITHTABLE_CONTAINER_READER = BUILDER.comment("\u5f00\u542f\u540e\uff0c\u4f7f\u7528\u67aa\u68b0\u5de5\u4f5c\u53f0\u5236\u4f5c\u4e1c\u897f\u65f6\u5c06\u8bfb\u53d6\u5468\u8fb9\u5bb9\u5668\u7684\u7269\u54c1\u3002").define("enableContainerReader", true);
        GUNSMITHTABLE_MASS_CRAFT_TIME = BUILDER.comment("\u5728\u8fd9\u91cc\u586b\u5165\u6b63\u6574\u6570\uff0c\u5373\u5236\u4f5c\u4e1c\u897f\u65f6\u6309\u4f4fSHIFT\u4f1a\u6279\u91cf\u5236\u4f5c\u7684\u6b21\u6570\u3002").define("enableMassCraftTime", (Object)4);
        BUILDER.pop();
        BUILDER.push("Attachment Setting");
        LESS_ALLOW_GUN = BUILDER.comment("\u5728\u8fd9\u91cc\u586b\u5165\u6b63\u6574\u6570\uff0c\u5373\u5bf9\u914d\u4ef6\u6309shift\u65f6\u663e\u793a\u7684\u9002\u7528\u67aa\u68b0\u6570\u91cf\u3002").define("enableLessAllowGun", (Object)16);
        SHOW_ATTACHMENT_ATTRIBUTE = BUILDER.comment("\u5f00\u542f\u540e\uff0c\u914d\u4ef6\u5c06\u663e\u793a\u8be6\u7ec6\u6570\u503c\u3002").define("enableAttachmentDetail", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

