/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.compat;

import com.mafuyu404.taczaddon.init.VirtualInventory;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestBackpackInventoryContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;

public class SophisticatedBackpacksCompatInner {
    public static ArrayList<ItemStack> getItemsFromBackpackBLock(BlockPos blockPos, Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BackpackContext.Block context = new BackpackContext.Block(blockPos);
        IBackpackWrapper wrapper = context.getBackpackWrapper(player);
        InventoryHandler backpack = wrapper.getInventoryHandler();
        int size = wrapper.getBackpack().m_41783_().m_128451_("inventorySlots");
        for (int i = 0; i < size; ++i) {
            items.add(backpack.getSlotStack(i));
        }
        return items;
    }

    public static void modifyBlockBackpack(ServerPlayer player, BlockPos blockPos, Consumer<IItemHandler> action) {
        BackpackContext.Block backpackContext = new BackpackContext.Block(blockPos);
        SophisticatedBackpacksCompatInner.modifyBackpack(player, (BackpackContext)backpackContext, action);
    }

    public static ArrayList<ItemStack> getItemsFromBackpackItem(ItemStack itemStack) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BackpackWrapper backpackWrapper = new BackpackWrapper(itemStack);
        InventoryHandler handler = backpackWrapper.getInventoryHandler();
        int size = itemStack.m_41783_().m_128451_("inventorySlots");
        for (int i = 0; i < size; ++i) {
            ItemStack item = handler.getStackInSlot(i);
            items.add(item);
        }
        return items;
    }

    public static ArrayList<ItemStack> getItemsFromInventoryBackpack(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        SophisticatedBackpacksCompatInner.getAllInventoryBackpack(player).forEach(itemStack -> items.addAll(SophisticatedBackpacksCompatInner.getItemsFromBackpackItem(itemStack)));
        return items;
    }

    public static void syncAllBackpack(Player player) {
        SophisticatedBackpacksCompatInner.getAllInventoryBackpack(player).forEach(itemStack -> {
            IBackpackWrapper backpackWrapper = (IBackpackWrapper)itemStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)IBackpackWrapper.Noop.INSTANCE);
            UUID uuid = (UUID)backpackWrapper.getContentsUuid().get();
            SBPPacketHandler.INSTANCE.sendToServer((Object)new RequestBackpackInventoryContentsMessage(uuid));
        });
    }

    public static void modifyInventoryBackpack(ServerPlayer player, ItemStack backpackItem, Consumer<IItemHandler> action) {
        PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, inventoryName, identifier, index) -> {
            if (!backpack.equals(backpackItem)) {
                return false;
            }
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, identifier, index);
            SophisticatedBackpacksCompatInner.modifyBackpack(player, (BackpackContext)backpackContext, action);
            return false;
        });
    }

    public static void modifyBackpack(ServerPlayer player, BackpackContext backpackContext, Consumer<IItemHandler> action) {
        int i;
        BackpackContainer container = new BackpackContainer(player.f_36096_.f_38840_ + 1, (Player)player, backpackContext);
        int size = container.realInventorySlots.size() - player.m_150109_().f_35974_.size();
        InventoryHandler inventoryHandler = ((IBackpackWrapper)container.getStorageWrapper()).getInventoryHandler();
        VirtualInventory virtualInventory = new VirtualInventory(size, (Player)player);
        for (i = 0; i < size; ++i) {
            virtualInventory.m_6836_(i, inventoryHandler.getStackInSlot(i));
        }
        action.accept(virtualInventory.getHandler());
        for (i = 0; i < size; ++i) {
            ((Slot)container.realInventorySlots.get(i)).m_5852_(virtualInventory.m_8020_(i));
        }
        UUID uuid = (UUID)((IBackpackWrapper)container.getStorageWrapper()).getContentsUuid().get();
        CompoundTag backpackContent = BackpackStorage.get().getOrCreateBackpackContents(uuid);
        SBPPacketHandler.INSTANCE.sendToClient(player, (Object)new BackpackContentsMessage(uuid, backpackContent));
    }

    public static ArrayList<ItemStack> getAllInventoryBackpack(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, index) -> {
            items.add(backpack);
            return false;
        });
        return items;
    }

    public static boolean isBackpackItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BackpackItem;
    }

    public static ArrayList<ItemStack> getItemsFromBackpackContext(Player player, BackpackContext backpackContext) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        BackpackContainer container = new BackpackContainer(player.f_36096_.f_38840_ + 1, player, backpackContext);
        int size = ((IBackpackWrapper)container.getStorageWrapper()).getBackpack().m_41783_().m_128451_("inventorySlots");
        for (int i = 0; i < size; ++i) {
            items.add(((Slot)container.realInventorySlots.get(i)).m_7993_());
        }
        return items;
    }
}

