/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import java.util.ArrayList;
import java.util.function.Consumer;

public class LayoutData {
    private final ArrayList<Consumer<MarkDownElementPosition>> elementListeners = new ArrayList();
    private final ArrayList<Consumer<MarkDownLine>> lineListeners = new ArrayList();
    private MarkDownLine currentLine = new MarkDownLine(0.0f);
    private MarkDownLine previousLine = null;
    private final float maxWidth;
    private boolean topSpacingLocked = false;
    private boolean bottomSpacingLocked = false;

    public LayoutData(float maxWidth) {
        this.maxWidth = maxWidth;
    }

    public boolean isLineEmpty() {
        return this.currentLine.width == 0.0f;
    }

    public boolean isLineOccupied() {
        return this.currentLine.width != 0.0f;
    }

    public boolean isLineModified() {
        return this.isLineOccupied() || this.currentLine.bottomSpacing != 0.0f || this.currentLine.height != 0.0f || this.currentLine.topSpacing != 0.0f;
    }

    public void nextLine() {
        if (this.isLineModified()) {
            this.lineListeners.forEach((Consumer<Consumer<MarkDownLine>>)((Consumer<Consumer>)listener -> listener.accept(this.currentLine)));
            this.previousLine = this.currentLine;
        }
        this.currentLine = new MarkDownLine(this.currentLine.getBottomY());
        this.topSpacingLocked = false;
        this.bottomSpacingLocked = false;
    }

    public MarkDownElementPosition addElement(LayoutStyle.Alignment alignment, float width, float height) {
        MarkDownElementPosition position = new MarkDownElementPosition(this.currentLine, this.currentLine.width, width, height, this.maxWidth, alignment);
        if (!this.elementListeners.isEmpty()) {
            this.elementListeners.get(0).accept(position);
        }
        this.addX(width);
        this.updateLineHeight(height);
        return position;
    }

    public void addElementListener(Consumer<MarkDownElementPosition> listener) {
        this.elementListeners.add(0, listener);
    }

    public void removeElementListener() {
        this.elementListeners.remove(0);
    }

    public void addLineListener(Consumer<MarkDownLine> listener) {
        this.lineListeners.add(0, listener);
    }

    public void removeLineListener() {
        this.lineListeners.remove(0);
    }

    public float getX() {
        return this.currentLine.width;
    }

    public void addX(float xMovement) {
        this.currentLine.width += xMovement;
    }

    public float getY() {
        return this.currentLine.y;
    }

    public float getLineHeight() {
        return this.currentLine.height;
    }

    public void setLineHeight(float lineHeight) {
        this.currentLine.height = lineHeight;
    }

    public void updateLineHeight(float lineHeight) {
        this.currentLine.height = Math.max(this.currentLine.height, lineHeight);
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public MarkDownLine getCurrentLine() {
        return this.currentLine;
    }

    public MarkDownLine getPreviousLine() {
        return this.previousLine;
    }

    public void updateTopSpacing(float spacing) {
        if (this.topSpacingLocked) {
            return;
        }
        this.currentLine.topSpacing = Math.max(this.currentLine.topSpacing, spacing);
    }

    public void updateBottomSpacing(float spacing) {
        if (this.bottomSpacingLocked) {
            return;
        }
        this.currentLine.bottomSpacing = Math.max(this.currentLine.bottomSpacing, spacing);
    }

    public void updatePadding(float padding) {
        this.updateTopSpacing(padding);
        this.updateBottomSpacing(padding);
    }

    public void setTopSpacing(float spacing) {
        if (this.topSpacingLocked) {
            return;
        }
        this.currentLine.topSpacing = spacing;
    }

    public void setBottomSpacing(float spacing) {
        if (this.bottomSpacingLocked) {
            return;
        }
        this.currentLine.bottomSpacing = spacing;
    }

    public void lockTopSpacing() {
        this.topSpacingLocked = true;
    }

    public void lockBottomSpacing() {
        this.bottomSpacingLocked = true;
    }

    public static class MarkDownLine {
        private final float y;
        private float width = 0.0f;
        private float height = 0.0f;
        private float topSpacing = 0.0f;
        private float bottomSpacing = 0.0f;

        public MarkDownLine(float y) {
            this.y = y;
        }

        public float getY() {
            return this.y;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.topSpacing + this.height + this.bottomSpacing;
        }

        public float getRawHeight() {
            return this.height;
        }

        public float getBottomY() {
            return this.y + this.getHeight();
        }

        public float getBottomSpacing() {
            return this.bottomSpacing;
        }

        public float getTopSpacing() {
            return this.topSpacing;
        }
    }

    public static class MarkDownElementPosition {
        private final MarkDownLine line;
        private final float x;
        private final float width;
        private final float height;
        private final float maxWidth;
        private final LayoutStyle.Alignment alignment;

        public MarkDownElementPosition(MarkDownLine line, float x, float width, float height, float maxWidth, LayoutStyle.Alignment alignment) {
            this.line = line;
            this.x = x;
            this.width = width;
            this.height = height;
            this.maxWidth = maxWidth;
            this.alignment = alignment;
        }

        public MarkDownLine getLine() {
            return this.line;
        }

        public float getX() {
            switch (this.alignment) {
                case LEFT: {
                    return this.x;
                }
                case CENTER: {
                    return this.maxWidth / 2.0f - this.line.width / 2.0f + this.x;
                }
                case RIGHT: {
                    return this.maxWidth - this.line.width + this.x;
                }
            }
            throw new IllegalStateException("Unknown alignment" + (Object)((Object)this.alignment));
        }

        public float getRightX() {
            return this.getX() + this.getWidth();
        }

        public float getY() {
            return this.getBottomY() - this.getHeight();
        }

        public float getBottomY() {
            return this.line.getBottomY() - this.line.getBottomSpacing();
        }

        public float getHeight() {
            return this.height;
        }

        public float getWidth() {
            return this.width;
        }

        public boolean isInside(float x, float y) {
            return x >= this.getX() && x <= this.getRightX() && y >= this.getY() && y <= this.getBottomY();
        }
    }
}

