/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium.compat.twilightforest.effects;

import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.event.ModularLooseProjectilesEvent;
import se.mickelus.tetra.gui.stats.StatsHelper;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatFormat;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterMultiValue;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class VerticalMultishotEffect {
    public static final ItemEffect verticalMultishotEffect = ItemEffect.get((String)"verticalMultishot");

    @SubscribeEvent
    public static void onModularLooseProjectiles(ModularLooseProjectilesEvent event) {
        ItemStack itemStack = event.getFiringStack();
        int verticalCount = EffectHelper.getEffectLevel((ItemStack)event.getFiringStack(), (ItemEffect)verticalMultishotEffect);
        if (verticalCount > 0 && event.getProjectileVelocity() > 0.1f && !event.getLevel().f_46443_) {
            int powerLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)itemStack);
            int punchLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44989_, (ItemStack)itemStack);
            int flameLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44990_, (ItemStack)itemStack);
            int piercingLevel = EffectHelper.getEffectLevel((ItemStack)itemStack, (ItemEffect)ItemEffect.piercing) + EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
            float spread = EffectHelper.getEffectEfficiency((ItemStack)event.getFiringStack(), (ItemEffect)verticalMultishotEffect);
            for (int i = 0; i < verticalCount; ++i) {
                int offset = (i / 2 + 1) * (i % 2 == 0 ? 1 : -1);
                double pitch = event.getBasePitch() + (double)(spread * (float)offset);
                ModularBowItem.fireProjectile((ItemStack)itemStack, (Level)event.getLevel(), (ArrowItem)((ArrowItem)event.getAmmoStack().m_41720_()), (ItemStack)event.getAmmoStack(), (ImmutableList)event.getProjectileRemappers(), (Player)event.getShooter(), (float)((float)pitch), (float)((float)event.getBaseYaw()), (float)event.getProjectileVelocity(), (float)event.getAccuracy(), (int)event.getDrawProgress(), (double)event.getStrength(), (int)powerLevel, (int)punchLevel, (int)flameLevel, (int)piercingLevel, (boolean)event.isHasSuspend(), (boolean)true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        StatGetterEffectLevel countGetter = new StatGetterEffectLevel(verticalMultishotEffect, 1.0);
        StatGetterEffectEfficiency spreadGetter = new StatGetterEffectEfficiency(verticalMultishotEffect, 1.0);
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.verticalMultishot", 0.0, 12.0, true, false, false, (IStatGetter)countGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterMultiValue("tetra.stats.verticalMultishot.tooltip", StatsHelper.withStats((IStatGetter[])new IStatGetter[]{countGetter, spreadGetter}), StatsHelper.withFormat((IStatFormat[])new IStatFormat[]{StatFormat.noDecimal, StatFormat.oneDecimal})));
        WorkbenchStatsGui.addBar((GuiStatBase)statBar);
        HoloStatsGui.addBar((GuiStatBase)statBar);
    }
}

